/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog2.bootstrap.CliCommand;

@Command(name="cert", description="Manage certificates for data-node", groupNames={"certutil"})
public class CertutilCert
implements CliCommand {
    public static final String DATANODE_KEY_ALIAS = "datanode";
    @Option(name={"--ca"}, description="Filename for the CA keystore")
    protected String caKeystoreFilename = "datanode-ca.p12";
    @Option(name={"--keystore"}, description="Filename for the generated keystore")
    protected String nodeKeystoreFilename = "datanode-transport-certificates.p12";
    private final CommandLineConsole console;

    public CertutilCert() {
        this.console = new SystemConsole();
    }

    public CertutilCert(String caKeystoreFilename, String nodeKeystoreFilename, CommandLineConsole console) {
        this.caKeystoreFilename = caKeystoreFilename;
        this.nodeKeystoreFilename = nodeKeystoreFilename;
        this.console = console;
    }

    @Override
    public void run() {
        this.console.printLine("This tool will generate a data-node certificate signed by provided certificate authority");
        Path caKeystorePath = Path.of(this.caKeystoreFilename, new String[0]);
        this.console.printLine("Using certificate authority " + caKeystorePath.toAbsolutePath());
        try {
            char[] password = this.console.readPassword("Enter CA password: ", new Object[0]);
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(new FileInputStream(caKeystorePath.toFile()), password);
            Key caPrivateKey = caKeystore.getKey("ca", password);
            X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
            X509Certificate rootCertificate = (X509Certificate)caKeystore.getCertificate("root");
            this.console.printLine("Successfully read CA from the keystore");
            KeyPair intermediateCA = new KeyPair((PrivateKey)caPrivateKey, null, caCertificate);
            this.console.printLine("Generating private key and certificate for this datanode");
            CertRequest req = CertRequest.signed("localhost", intermediateCA).validity(Duration.ofDays(3650L));
            KeyPair nodePair = CertificateGenerator.generate(req);
            KeyStore nodeKeystore = KeyStore.getInstance("PKCS12");
            nodeKeystore.load(null, null);
            char[] nodeKeystorePassword = this.console.readPassword("Enter datanode certificate password: ", new Object[0]);
            nodeKeystore.setKeyEntry(DATANODE_KEY_ALIAS, nodePair.privateKey(), nodeKeystorePassword, new X509Certificate[]{nodePair.certificate(), intermediateCA.certificate(), rootCertificate});
            Path nodeKeystorePath = Path.of(this.nodeKeystoreFilename, new String[0]);
            try (FileOutputStream store = new FileOutputStream(nodeKeystorePath.toFile());){
                nodeKeystore.store(store, nodeKeystorePassword);
                this.console.printLine("Private key and certificate for this datanode successfully saved into " + nodeKeystorePath.toAbsolutePath());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

