/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.converters.StringListConverter;
import com.github.joschi.jadconfig.converters.StringSetConverter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.util.Size;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.PositiveLongValidator;
import com.github.joschi.jadconfig.validators.StringNotBlankValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.configuration.DurationCastedToIntegerValidator;
import org.graylog2.configuration.validators.RetentionStrategyValidator;
import org.graylog2.configuration.validators.RotationStrategyValidator;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.Period;
import org.joda.time.base.BaseSingleFieldPeriod;

public class ElasticsearchConfiguration {
    public static final String MAX_INDEX_RETENTION_PERIOD = "max_index_retention_period";
    public static final String DEFAULT_EVENTS_INDEX_PREFIX = "default_events_index_prefix";
    public static final String DEFAULT_SYSTEM_EVENTS_INDEX_PREFIX = "default_system_events_index_prefix";
    public static final String TIME_SIZE_OPTIMIZING_RETENTION_MIN_LIFETIME = "time_size_optimizing_retention_min_lifetime";
    public static final String TIME_SIZE_OPTIMIZING_RETENTION_MAX_LIFETIME = "time_size_optimizing_retention_max_lifetime";
    public static final String TIME_SIZE_OPTIMIZING_ROTATION_MIN_SHARD_SIZE = "time_size_optimizing_rotation_min_shard_size";
    public static final String TIME_SIZE_OPTIMIZING_ROTATION_MAX_SHARD_SIZE = "time_size_optimizing_rotation_max_shard_size";
    public static final String TIME_SIZE_OPTIMIZING_ROTATION_PERIOD = "time_size_optimizing_rotation_period";
    @Parameter(value="elasticsearch_index_prefix", required=true)
    private String defaultIndexPrefix = "graylog";
    @Parameter(value="elasticsearch_template_name")
    private String defaultIndexTemplateName = "graylog-internal";
    @Parameter(value="default_events_index_prefix", validators={StringNotBlankValidator.class})
    private String defaultEventsIndexPrefix = "gl-events";
    @Parameter(value="default_system_events_index_prefix", validators={StringNotBlankValidator.class})
    private String defaultSystemEventsIndexPrefix = "gl-system-events";
    @Parameter(value="elasticsearch_analyzer", required=true)
    private String analyzer = "standard";
    @Parameter(value="elasticsearch_shards", validators={PositiveIntegerValidator.class}, required=true)
    private int shards = 1;
    @Parameter(value="elasticsearch_replicas", validators={PositiveIntegerValidator.class}, required=true)
    private int replicas = 0;
    @Parameter(value="disable_index_optimization")
    private boolean disableIndexOptimization = false;
    @Parameter(value="index_optimization_max_num_segments", validators={PositiveIntegerValidator.class})
    private int indexOptimizationMaxNumSegments = 1;
    @Parameter(value="index_field_type_periodical_full_refresh_interval", validators={PositiveDurationValidator.class})
    private Duration indexFieldTypePeriodicalFullRefreshInterval = Duration.minutes((long)5L);
    @Parameter(value="retention_strategy", required=true)
    private String retentionStrategy = "delete";
    @Parameter(value="disabled_retention_strategies", required=true, converter=StringSetConverter.class, validators={RetentionStrategyValidator.class})
    private Set<String> disabledRetentionStrategies = Collections.emptySet();
    @Parameter(value="rotation_strategy", required=true)
    private String rotationStrategy = "time-size-optimizing";
    @Parameter(value="elasticsearch_max_time_per_index", required=true)
    private Period maxTimePerIndex = Period.days((int)1);
    @Parameter(value="elasticsearch_rotate_empty_index_set", required=true)
    private boolean rotateEmptyIndex = false;
    @Parameter(value="elasticsearch_max_docs_per_index", validators={PositiveIntegerValidator.class}, required=true)
    private int maxDocsPerIndex = 20000000;
    @Parameter(value="elasticsearch_max_size_per_index", validators={PositiveLongValidator.class}, required=true)
    private long maxSizePerIndex = 0x780000000L;
    @Parameter(value="elasticsearch_max_number_of_indices", required=true, validators={PositiveIntegerValidator.class})
    private int maxNumberOfIndices = 20;
    @Parameter(value="time_size_optimizing_rotation_period")
    private Period timeSizeOptimizingRotationPeriod = Period.days((int)1);
    @Parameter(value="time_size_optimizing_rotation_min_shard_size")
    private Size timeSizeOptimizingRotationMinShardSize = Size.gigabytes((long)20L);
    @Parameter(value="time_size_optimizing_rotation_max_shard_size")
    private Size timeSizeOptimizingRotationMaxShardSize = Size.gigabytes((long)50L);
    @Parameter(value="time_size_optimizing_retention_min_lifetime")
    private Period timeSizeOptimizingRotationMinLifeTime = TimeBasedSizeOptimizingStrategyConfig.DEFAULT_LIFETIME_MIN;
    @Parameter(value="time_size_optimizing_retention_max_lifetime")
    private Period timeSizeOptimizingRotationMaxLifeTime = TimeBasedSizeOptimizingStrategyConfig.DEFAULT_LIFETIME_MAX;
    @Parameter(value="elasticsearch_disable_version_check")
    private boolean disableVersionCheck = false;
    @Parameter(value="elasticsearch_max_write_index_age")
    private Period maxWriteIndexAge = null;
    @Parameter(value="no_retention")
    private boolean noRetention = false;
    @Parameter(value="enabled_index_rotation_strategies", converter=StringListConverter.class, validators={RotationStrategyValidator.class})
    private List<String> enabledRotationStrategies = Arrays.asList("time", "count", "size", "time-size-optimizing");
    @Parameter(value="max_index_retention_period")
    private Period maxIndexRetentionPeriod = null;
    @Parameter(value="elasticsearch_index_optimization_timeout", validators={DurationCastedToIntegerValidator.class})
    private Duration indexOptimizationTimeout = Duration.hours((long)1L);
    @Parameter(value="elasticsearch_index_optimization_jobs", validators={PositiveIntegerValidator.class})
    private int indexOptimizationJobs = 10;

    @Nullable
    public Period getMaxIndexRetentionPeriod() {
        return this.maxIndexRetentionPeriod;
    }

    public String getDefaultIndexPrefix() {
        return this.defaultIndexPrefix.toLowerCase(Locale.ENGLISH);
    }

    public String getDefaultIndexTemplateName() {
        return this.defaultIndexTemplateName;
    }

    public String getDefaultEventsIndexPrefix() {
        return this.defaultEventsIndexPrefix;
    }

    public String getDefaultSystemEventsIndexPrefix() {
        return this.defaultSystemEventsIndexPrefix;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public int getShards() {
        return this.shards;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public int getIndexOptimizationMaxNumSegments() {
        return this.indexOptimizationMaxNumSegments;
    }

    public boolean isDisableIndexOptimization() {
        return this.disableIndexOptimization;
    }

    public Duration getIndexFieldTypePeriodicalFullRefreshInterval() {
        return this.indexFieldTypePeriodicalFullRefreshInterval;
    }

    public String getRotationStrategy() {
        return this.rotationStrategy;
    }

    public String getRetentionStrategy() {
        return this.retentionStrategy;
    }

    public Set<String> getDisabledRetentionStrategies() {
        return this.disabledRetentionStrategies;
    }

    public Period getMaxTimePerIndex() {
        return this.maxTimePerIndex;
    }

    public boolean isRotateEmptyIndex() {
        return this.rotateEmptyIndex;
    }

    public int getMaxDocsPerIndex() {
        return this.maxDocsPerIndex;
    }

    public long getMaxSizePerIndex() {
        return this.maxSizePerIndex;
    }

    public int getMaxNumberOfIndices() {
        return this.maxNumberOfIndices;
    }

    public Period getTimeSizeOptimizingRotationPeriod() {
        return this.timeSizeOptimizingRotationPeriod;
    }

    public Size getTimeSizeOptimizingRotationMinShardSize() {
        return this.timeSizeOptimizingRotationMinShardSize;
    }

    public Size getTimeSizeOptimizingRotationMaxShardSize() {
        return this.timeSizeOptimizingRotationMaxShardSize;
    }

    public Period getTimeSizeOptimizingRotationMinLifeTime() {
        return this.timeSizeOptimizingRotationMinLifeTime;
    }

    public Period getTimeSizeOptimizingRotationMaxLifeTime() {
        return this.timeSizeOptimizingRotationMaxLifeTime;
    }

    public boolean isDisableVersionCheck() {
        return this.disableVersionCheck;
    }

    public Period getMaxWriteIndexAge() {
        return this.maxWriteIndexAge;
    }

    public List<String> getEnabledRotationStrategies() {
        return this.enabledRotationStrategies;
    }

    public boolean performRetention() {
        return !this.noRetention;
    }

    public Duration getIndexOptimizationTimeout() {
        return this.indexOptimizationTimeout;
    }

    public int getIndexOptimizationJobs() {
        return this.indexOptimizationJobs;
    }

    @ValidatorMethod
    public void validateTimeSizeOptimizingRotation() throws ValidationException {
        if (this.getTimeSizeOptimizingRotationMaxShardSize().compareTo(this.getTimeSizeOptimizingRotationMinShardSize()) < 0) {
            throw new ValidationException(StringUtils.f("\"%s=%s\" cannot be larger than \"%s=%s\"", TIME_SIZE_OPTIMIZING_ROTATION_MIN_SHARD_SIZE, this.getTimeSizeOptimizingRotationMinShardSize(), TIME_SIZE_OPTIMIZING_ROTATION_MAX_SHARD_SIZE, this.getTimeSizeOptimizingRotationMaxShardSize()));
        }
        if (this.getTimeSizeOptimizingRotationMaxLifeTime().toStandardSeconds().compareTo((BaseSingleFieldPeriod)this.getTimeSizeOptimizingRotationMinLifeTime().toStandardSeconds()) <= 0) {
            throw new ValidationException(StringUtils.f("\"%s=%s\" needs to be larger than \"%s=%s\"", TIME_SIZE_OPTIMIZING_RETENTION_MAX_LIFETIME, this.getTimeSizeOptimizingRotationMaxLifeTime(), TIME_SIZE_OPTIMIZING_RETENTION_MIN_LIFETIME, this.getTimeSizeOptimizingRotationMinLifeTime()));
        }
        if (this.getMaxIndexRetentionPeriod() != null && this.getMaxIndexRetentionPeriod().toStandardSeconds().compareTo((BaseSingleFieldPeriod)this.getTimeSizeOptimizingRotationMaxLifeTime().toStandardSeconds()) < 0) {
            throw new ValidationException(StringUtils.f("\"%s=%s\" cannot to be larger than \"%s=%s\"", TIME_SIZE_OPTIMIZING_RETENTION_MAX_LIFETIME, this.getTimeSizeOptimizingRotationMaxLifeTime(), MAX_INDEX_RETENTION_PERIOD, this.getMaxIndexRetentionPeriod()));
        }
    }
}

