/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.configuration.AutoValue_IndexSetsDefaultConfiguration;
import org.graylog2.plugin.PluginConfigBean;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_IndexSetsDefaultConfiguration.Builder.class)
@AutoValue
public abstract class IndexSetsDefaultConfiguration
implements PluginConfigBean {
    public static final String INDEX_ANALYZER = "index_analyzer";
    public static final String SHARDS = "shards";
    public static final String REPLICAS = "replicas";
    public static final String INDEX_OPTIMIZATION_DISABLED = "index_optimization_disabled";
    public static final String INDEX_OPTIMIZATION_MAX_SEGMENTS = "index_optimization_max_num_segments";
    public static final String FIELD_TYPE_REFRESH_INTERVAL = "field_type_refresh_interval";
    public static final String FIELD_TYPE_REFRESH_INTERVAL_UNIT = "field_type_refresh_interval_unit";
    public static final String ROTATION_STRATEGY_CLASS = "rotation_strategy_class";
    public static final String ROTATION_STRATEGY_CONFIG = "rotation_strategy_config";
    public static final String ROTATION_STRATEGY = "rotation_strategy";
    public static final String RETENTION_STRATEGY_CLASS = "retention_strategy_class";
    public static final String RETENTION_STRATEGY_CONFIG = "retention_strategy_config";
    public static final String RETENTION_STRATEGY = "retention_strategy";

    @NotBlank
    @JsonProperty(value="index_analyzer")
    public abstract String indexAnalyzer();

    @Min(value=1L)
    @JsonProperty(value="shards")
    public abstract @Min(value=1L) int shards();

    @Min(value=0L)
    @JsonProperty(value="replicas")
    public abstract @Min(value=0L) int replicas();

    @Min(value=1L)
    @JsonProperty(value="index_optimization_max_num_segments")
    public abstract @Min(value=1L) int indexOptimizationMaxNumSegments();

    @JsonProperty(value="index_optimization_disabled")
    public abstract boolean indexOptimizationDisabled();

    @Min(value=0L)
    @JsonProperty(value="field_type_refresh_interval")
    public abstract @Min(value=0L) long fieldTypeRefreshInterval();

    @JsonProperty(value="field_type_refresh_interval_unit")
    public abstract TimeUnit fieldTypeRefreshIntervalUnit();

    @NotBlank
    @JsonProperty(value="rotation_strategy_class")
    public abstract String rotationStrategyClass();

    @NotNull
    @JsonProperty(value="rotation_strategy_config")
    public abstract RotationStrategyConfig rotationStrategyConfig();

    @NotNull
    @JsonProperty(value="rotation_strategy")
    public RotationStrategyConfig rotationStrategy() {
        return this.rotationStrategyConfig();
    }

    @NotBlank
    @JsonProperty(value="retention_strategy_class")
    public abstract String retentionStrategyClass();

    @NotNull
    @JsonProperty(value="retention_strategy_config")
    public abstract RetentionStrategyConfig retentionStrategyConfig();

    @NotNull
    @JsonProperty(value="retention_strategy")
    public RetentionStrategyConfig retentionStrategy() {
        return this.retentionStrategyConfig();
    }

    public static Builder builder() {
        return new AutoValue_IndexSetsDefaultConfiguration.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="index_analyzer")
        public abstract Builder indexAnalyzer(String var1);

        @JsonProperty(value="shards")
        public abstract Builder shards(int var1);

        @JsonProperty(value="replicas")
        public abstract Builder replicas(int var1);

        @JsonProperty(value="index_optimization_max_num_segments")
        public abstract Builder indexOptimizationMaxNumSegments(int var1);

        @JsonProperty(value="index_optimization_disabled")
        public abstract Builder indexOptimizationDisabled(boolean var1);

        @JsonProperty(value="field_type_refresh_interval")
        public abstract Builder fieldTypeRefreshInterval(long var1);

        @JsonProperty(value="field_type_refresh_interval_unit")
        public abstract Builder fieldTypeRefreshIntervalUnit(TimeUnit var1);

        @JsonProperty(value="rotation_strategy_class")
        public abstract Builder rotationStrategyClass(String var1);

        @JsonProperty(value="rotation_strategy_config")
        public abstract Builder rotationStrategyConfig(RotationStrategyConfig var1);

        @JsonProperty(value="rotation_strategy")
        public Builder rotationStrategy(RotationStrategyConfig rotationStrategyConfig) {
            return this.rotationStrategyConfig(rotationStrategyConfig);
        }

        @JsonProperty(value="retention_strategy_class")
        public abstract Builder retentionStrategyClass(String var1);

        @JsonProperty(value="retention_strategy_config")
        public abstract Builder retentionStrategyConfig(RetentionStrategyConfig var1);

        @JsonProperty(value="retention_strategy")
        public Builder retentionStrategy(RetentionStrategyConfig retentionStrategyConfig) {
            return this.retentionStrategyConfig(retentionStrategyConfig);
        }

        public abstract IndexSetsDefaultConfiguration build();
    }
}

