/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.AutoValue_IndexSetValidator_Violation;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategyConfig;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class IndexSetValidator {
    private static final Duration MINIMUM_FIELD_TYPE_REFRESH_INTERVAL = Duration.standardSeconds((long)1L);
    private final IndexSetRegistry indexSetRegistry;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public IndexSetValidator(IndexSetRegistry indexSetRegistry, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.indexSetRegistry = indexSetRegistry;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    public Optional<Violation> validate(IndexSetConfig newConfig) {
        Violation prefixViolation;
        if (Strings.isNullOrEmpty((String)newConfig.id()) && (prefixViolation = this.validatePrefix(newConfig)) != null) {
            return Optional.of(prefixViolation);
        }
        Violation refreshIntervalViolation = this.validateRefreshInterval(newConfig.fieldTypeRefreshInterval());
        if (refreshIntervalViolation != null) {
            return Optional.of(refreshIntervalViolation);
        }
        Violation rotationViolation = this.validateRotation(newConfig.rotationStrategy());
        if (rotationViolation != null) {
            return Optional.of(rotationViolation);
        }
        Violation retentionConfigViolation = this.validateRetentionConfig(newConfig.retentionStrategy());
        if (retentionConfigViolation != null) {
            return Optional.of(retentionConfigViolation);
        }
        return Optional.ofNullable(this.validateRetentionPeriod(newConfig.rotationStrategy(), newConfig.retentionStrategy()));
    }

    @Nullable
    public Violation validateRefreshInterval(Duration readableDuration) {
        if (readableDuration.isShorterThan((ReadableDuration)MINIMUM_FIELD_TYPE_REFRESH_INTERVAL)) {
            return Violation.create("Index field_type_refresh_interval \"" + readableDuration.toString() + "\" is too short. It must be 1 second or longer.");
        }
        return null;
    }

    @Nullable
    private Violation validatePrefix(IndexSetConfig newConfig) {
        String indexName = newConfig.indexPrefix() + "_0";
        if (this.indexSetRegistry.isManagedIndex(indexName)) {
            return Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with an existing index set!");
        }
        for (IndexSet indexSet : this.indexSetRegistry) {
            if (!newConfig.indexPrefix().startsWith(indexSet.getIndexPrefix()) && !indexSet.getIndexPrefix().startsWith(newConfig.indexPrefix())) continue;
            return Violation.create("Index prefix \"" + newConfig.indexPrefix() + "\" would conflict with existing index set prefix \"" + indexSet.getIndexPrefix() + "\"");
        }
        return null;
    }

    @Nullable
    public Violation validateRotation(RotationStrategyConfig rotationStrategyConfig) {
        if (rotationStrategyConfig instanceof TimeBasedSizeOptimizingStrategyConfig) {
            TimeBasedSizeOptimizingStrategyConfig config = (TimeBasedSizeOptimizingStrategyConfig)rotationStrategyConfig;
            Period leeway = config.indexLifetimeMax().minus((ReadablePeriod)config.indexLifetimeMin());
            if (leeway.toStandardSeconds().getSeconds() < 0) {
                return Violation.create(StringUtils.f("%s <%s> is shorter than %s <%s>", "index_lifetime_max", config.indexLifetimeMax(), "index_lifetime_min", config.indexLifetimeMin()));
            }
            if (leeway.toStandardSeconds().isLessThan(this.elasticsearchConfiguration.getTimeSizeOptimizingRotationPeriod().toStandardSeconds())) {
                return Violation.create(StringUtils.f("The duration between %s and %s <%s> cannot be shorter than %s <%s>", "index_lifetime_max", "index_lifetime_min", leeway, "time_size_optimizing_rotation_period", this.elasticsearchConfiguration.getTimeSizeOptimizingRotationPeriod()));
            }
            Period maxRetentionPeriod = this.elasticsearchConfiguration.getMaxIndexRetentionPeriod();
            if (maxRetentionPeriod != null && config.indexLifetimeMax().toStandardSeconds().isGreaterThan(maxRetentionPeriod.toStandardSeconds())) {
                return Violation.create(StringUtils.f("Lifetime setting %s <%s> exceeds the configured maximum of %s=%s.", "index_lifetime_max", config.indexLifetimeMax(), "max_index_retention_period", maxRetentionPeriod));
            }
            if (this.periodOtherThanDays(config.indexLifetimeMax())) {
                return Violation.create(StringUtils.f("Lifetime setting %s <%s> can only be a multiple of days", "index_lifetime_max", config.indexLifetimeMax()));
            }
            if (this.periodOtherThanDays(config.indexLifetimeMin())) {
                return Violation.create(StringUtils.f("Lifetime setting %s <%s> can only be a multiple of days", "index_lifetime_min", config.indexLifetimeMin()));
            }
        }
        return null;
    }

    @VisibleForTesting
    boolean periodOtherThanDays(Period period) {
        return Arrays.stream(period.getFieldTypes()).filter(type -> !type.equals(DurationFieldType.days())).anyMatch(type -> period.get(type) != 0);
    }

    @Nullable
    public Violation validateRetentionPeriod(RotationStrategyConfig rotationStrategyConfig, RetentionStrategyConfig retentionStrategyConfig) {
        Period maxRetentionPeriod = this.elasticsearchConfiguration.getMaxIndexRetentionPeriod();
        if (maxRetentionPeriod == null) {
            return null;
        }
        if (!(rotationStrategyConfig instanceof TimeBasedRotationStrategyConfig)) {
            return null;
        }
        Period rotationPeriod = ((TimeBasedRotationStrategyConfig)rotationStrategyConfig).rotationPeriod().normalizedStandard();
        Period effectiveRetentionPeriod = rotationPeriod.multipliedBy(retentionStrategyConfig.maxNumberOfIndices()).normalizedStandard();
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        if (now.plus((ReadablePeriod)effectiveRetentionPeriod).isAfter((ReadableInstant)now.plus((ReadablePeriod)maxRetentionPeriod))) {
            return Violation.create(StringUtils.f("Index retention setting %s=%d would result in an effective index retention period of %s. This exceeds the configured maximum of %s=%s.", "max_number_of_indices", retentionStrategyConfig.maxNumberOfIndices(), effectiveRetentionPeriod, "max_index_retention_period", maxRetentionPeriod));
        }
        return null;
    }

    @Nullable
    public Violation validateRetentionConfig(RetentionStrategyConfig retentionStrategyConfig) {
        ValidationResult validationResult = retentionStrategyConfig.validate(this.elasticsearchConfiguration);
        if (validationResult.failed()) {
            Optional error = validationResult.getErrors().keySet().stream().findFirst();
            return Violation.create(error.orElse("Unknown retention config validation error"));
        }
        return null;
    }

    @AutoValue
    public static abstract class Violation {
        public abstract String message();

        public static Violation create(String message) {
            return new AutoValue_IndexSetValidator_Violation(message);
        }
    }
}

