/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.FirstSuccessfulStrategy;
import org.apache.shiro.realm.Realm;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;

public class ThrowingFirstSuccessfulStrategy
extends FirstSuccessfulStrategy {
    private AuthenticationServiceUnavailableException unavailableException;

    public AuthenticationInfo beforeAllAttempts(Collection<? extends Realm> realms, AuthenticationToken token) throws AuthenticationException {
        this.unavailableException = null;
        return super.beforeAllAttempts(realms, token);
    }

    public AuthenticationInfo afterAttempt(Realm realm, AuthenticationToken token, AuthenticationInfo singleRealmInfo, AuthenticationInfo aggregateInfo, Throwable t) throws AuthenticationException {
        if (t instanceof AuthenticationServiceUnavailableException) {
            this.unavailableException = (AuthenticationServiceUnavailableException)((Object)t);
        }
        return super.afterAttempt(realm, token, singleRealmInfo, aggregateInfo, t);
    }

    public AuthenticationInfo afterAllAttempts(AuthenticationToken token, AuthenticationInfo aggregate) throws AuthenticationServiceUnavailableException {
        AuthenticationInfo authenticationInfo = super.afterAllAttempts(token, aggregate);
        if (authenticationInfo == null && this.unavailableException != null) {
            throw this.unavailableException;
        }
        return authenticationInfo;
    }
}

