/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.utilities;

import com.google.common.base.Throwables;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExceptionUtils {
    public static Throwable getRootCause(Throwable t) {
        return ExceptionUtils.getRootCause(t, false);
    }

    public static Throwable getRootCause(Throwable t, boolean causeNeedsMessage) {
        if (t == null) {
            return null;
        }
        Throwable rootCause = t;
        for (Throwable cause = rootCause.getCause(); cause != null && (!causeNeedsMessage || StringUtils.isNotBlank((CharSequence)cause.getMessage())) && cause != rootCause; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }

    public static String formatMessageCause(Throwable t) {
        if (t == null) {
            return "Unknown cause";
        }
        StringBuilder causeMessage = new StringBuilder();
        String message = t.getMessage();
        if (t.getClass() == UnknownHostException.class) {
            causeMessage.append("Unknown host '");
            causeMessage.append(message);
            causeMessage.append("'");
        } else {
            causeMessage.append(message);
        }
        if (message != null && !message.endsWith(".") && !message.endsWith("!")) {
            causeMessage.append(".");
        }
        return causeMessage.toString();
    }

    public static String getRootCauseMessage(Throwable t) {
        return ExceptionUtils.formatMessageCause(ExceptionUtils.getRootCause(t));
    }

    public static String getRootCauseOrMessage(Throwable t) {
        Throwable rootCause = ExceptionUtils.getRootCause(t, true);
        return ExceptionUtils.formatMessageCause(rootCause != null ? rootCause : t);
    }

    public static boolean hasCauseOf(Throwable t, Class<? extends Throwable> causeType) {
        return Throwables.getCausalChain((Throwable)t).stream().anyMatch(c -> causeType.isAssignableFrom(c.getClass()));
    }

    public static String getShortenedStackTrace(Throwable t) {
        StringBuilder trace = new StringBuilder();
        List causalChain = Throwables.getCausalChain((Throwable)t).stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getMessage())).collect(Collectors.toList());
        int position = 0;
        for (Throwable c2 : causalChain) {
            if (position > 0) {
                trace.append("Caused by: ");
            }
            ExceptionUtils.appendWithNewline(trace, c2);
            Arrays.stream(c2.getStackTrace()).findFirst().ifPresent(firstStackElement -> {
                trace.append("\tat ");
                ExceptionUtils.appendWithNewline(trace, firstStackElement);
                int more = c2.getStackTrace().length - 1;
                if (more > 0) {
                    trace.append("\t... ").append(more);
                    ExceptionUtils.appendWithNewline(trace, " more");
                }
            });
            ++position;
        }
        return trace.toString();
    }

    private static StringBuilder appendWithNewline(StringBuilder stringBuilder, Object append) {
        return stringBuilder.append(append).append(System.lineSeparator());
    }
}

