/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.shutdown;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import org.graylog2.system.shutdown.GracefulShutdownHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GracefulShutdownService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownService.class);
    private final Set<GracefulShutdownHook> shutdownHooks = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean isShuttingDown = new AtomicBoolean(false);

    protected void startUp() {
    }

    protected void shutDown() {
        if (this.isShuttingDown.getAndSet(true) || this.shutdownHooks.isEmpty()) {
            return;
        }
        try {
            ExecutorService executor = this.executorService(Math.min(this.shutdownHooks.size(), 10));
            CountDownLatch latch = new CountDownLatch(this.shutdownHooks.size());
            LOG.info("Running graceful shutdown for <{}> shutdown hooks", (Object)this.shutdownHooks.size());
            for (GracefulShutdownHook shutdownHook : this.shutdownHooks) {
                executor.submit(() -> {
                    String hookName = shutdownHook.getClass().getSimpleName();
                    try {
                        LOG.info("Initiate shutdown for <{}>", (Object)hookName);
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        shutdownHook.doGracefulShutdown();
                        LOG.info("Finished shutdown for <{}>, took {} ms", (Object)hookName, (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                    }
                    catch (Exception e) {
                        LOG.error("Problem shutting down <{}>", (Object)hookName, (Object)e);
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            latch.await();
            executor.shutdown();
        }
        catch (Exception e) {
            LOG.error("Problem shutting down registered hooks", (Throwable)e);
        }
    }

    public void register(GracefulShutdownHook shutdownHook) {
        if (this.isShuttingDown.get()) {
            throw new IllegalStateException("Couldn't register shutdown hook because shutdown is already in progress");
        }
        this.shutdownHooks.add(Objects.requireNonNull(shutdownHook, "shutdownHook cannot be null"));
    }

    public void unregister(GracefulShutdownHook shutdownHook) {
        if (this.isShuttingDown.get()) {
            throw new IllegalStateException("Couldn't unregister shutdown hook because shutdown is already in progress");
        }
        this.shutdownHooks.remove(Objects.requireNonNull(shutdownHook, "shutdownHook cannot be null"));
    }

    private ExecutorService executorService(int maxThreads) {
        return new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("graceful-shutdown-service-%d").setUncaughtExceptionHandler((t, e) -> LOG.error("Uncaught exception in <{}>", (Object)t, (Object)e)).build());
    }
}

