/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.JsonFlattener;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.system.stats.elasticsearch.NodeInfo;
import org.graylog2.telemetry.enterprise.TelemetryLicenseStatus;
import org.graylog2.telemetry.rest.TelemetryUserSettings;
import org.joda.time.DateTime;

class TelemetryResponseFactory {
    private static final String CURRENT_USER = "current_user";
    private static final String USER_TELEMETRY_SETTINGS = "user_telemetry_settings";
    private static final String CLUSTER = "cluster";
    private static final String LICENSE = "license";
    private static final String PLUGIN = "plugin";
    private static final String SEARCH_CLUSTER = "search_cluster";
    private final ObjectMapper objectMapper;

    @Inject
    public TelemetryResponseFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static boolean isLeader(Map<String, Object> n) {
        Object object = n.get("is_leader");
        if (object instanceof Boolean) {
            Boolean isLeader = (Boolean)object;
            return isLeader;
        }
        return false;
    }

    Map<String, Object> createTelemetryResponse(Map<String, Object> clusterInfo, Map<String, Object> userInfo, Map<String, Object> pluginInfo, Map<String, Object> searchClusterInfo, List<TelemetryLicenseStatus> licenseStatuses, TelemetryUserSettings telemetryUserSettings) {
        LinkedHashMap<String, Object> telemetryResponse = new LinkedHashMap<String, Object>();
        telemetryResponse.put(CURRENT_USER, userInfo);
        telemetryResponse.put(USER_TELEMETRY_SETTINGS, telemetryUserSettings);
        telemetryResponse.put(CLUSTER, clusterInfo);
        telemetryResponse.put(LICENSE, this.createLicenseInfo(licenseStatuses));
        telemetryResponse.put(PLUGIN, pluginInfo);
        telemetryResponse.put(SEARCH_CLUSTER, searchClusterInfo);
        return telemetryResponse;
    }

    Map<String, Object> createTelemetryDisabledResponse(TelemetryUserSettings telemetryUserSettings) {
        return Map.of(USER_TELEMETRY_SETTINGS, telemetryUserSettings);
    }

    Map<String, Object> createUserInfo(String userHash, boolean isLocalAdmin, int rolesCount, int teamsCount) {
        LinkedHashMap<String, Object> userInfo = new LinkedHashMap<String, Object>();
        userInfo.put("user", userHash);
        userInfo.putAll(this.flatten(Map.of(CURRENT_USER, Map.of("is_local_admin", isLocalAdmin, "roles_count", rolesCount, "teams_count", teamsCount))));
        return userInfo;
    }

    Map<String, Object> createClusterInfo(String clusterId, DateTime clusterCreationDate, Map<String, Map<String, Object>> nodes, long averageLastMonthTraffic, long usersCount, int licenseCount) {
        LinkedHashMap<String, Object> clusterInfo = new LinkedHashMap<String, Object>();
        clusterInfo.put("cluster_id", clusterId);
        clusterInfo.put("cluster_creation_date", clusterCreationDate);
        clusterInfo.put("nodes_count", nodes.size());
        clusterInfo.put("average_last_month_traffic", averageLastMonthTraffic);
        clusterInfo.put("users_count", usersCount);
        clusterInfo.put("license_count", licenseCount);
        clusterInfo.put("node_leader.app_version", this.leaderNodeVersion(nodes));
        clusterInfo.put("nodes", nodes);
        return clusterInfo;
    }

    private Object leaderNodeVersion(Map<String, Map<String, Object>> nodes) {
        return nodes.values().stream().filter(TelemetryResponseFactory::isLeader).map(stringObjectMap -> stringObjectMap.get("version")).findFirst().orElse("unknown");
    }

    Map<String, Object> createPluginInfo(boolean isEnterprisePluginInstalled, List<String> plugins) {
        LinkedHashMap<String, Object> userInfo = new LinkedHashMap<String, Object>();
        userInfo.put(StringUtils.f("%s.is_enterprise_plugin_installed", PLUGIN), isEnterprisePluginInstalled);
        userInfo.putAll(this.flatten(Map.of(PLUGIN, Map.of("installed_plugins", plugins))));
        return userInfo;
    }

    Map<String, Object> createSearchClusterInfo(int nodesCount, String version, Map<String, NodeInfo> nodes) {
        LinkedHashMap<String, Object> userInfo = new LinkedHashMap<String, Object>();
        userInfo.put(StringUtils.f("%s.nodes_count", SEARCH_CLUSTER), nodesCount);
        userInfo.put(StringUtils.f("%s.version", SEARCH_CLUSTER), version);
        userInfo.putAll(this.flatten(Map.of(SEARCH_CLUSTER, Map.of("nodes", nodes))));
        return userInfo;
    }

    private Map<String, Object> createLicenseInfo(List<TelemetryLicenseStatus> telemetryLicenseStatuses) {
        Map<String, List<TelemetryLicenseStatus>> groupedBySubject = telemetryLicenseStatuses.stream().collect(Collectors.groupingBy(TelemetryLicenseStatus::subject));
        List uniqueLicenses = groupedBySubject.values().stream().map(this::filter).flatMap(Collection::stream).toList();
        LinkedHashMap<String, Object> licenses = new LinkedHashMap<String, Object>();
        for (TelemetryLicenseStatus l : uniqueLicenses) {
            String licenseString = this.formatLicenseString(l);
            licenses.put(StringUtils.f("%s.expired", licenseString), l.expired());
            licenses.put(StringUtils.f("%s.valid", licenseString), l.valid());
            licenses.put(StringUtils.f("%s.violated", licenseString), l.violated());
            licenses.put(StringUtils.f("%s.expiration_date", licenseString), l.expirationDate());
            licenses.put(StringUtils.f("%s.traffic_limit", licenseString), l.trafficLimit());
        }
        return licenses;
    }

    private List<TelemetryLicenseStatus> filter(List<TelemetryLicenseStatus> telemetryLicenseStatuses1) {
        Comparator<TelemetryLicenseStatus> compareIsValid = Comparator.comparing(TelemetryLicenseStatus::valid).reversed();
        Comparator<TelemetryLicenseStatus> compareIsExpired = Comparator.comparing(TelemetryLicenseStatus::expired);
        Comparator<TelemetryLicenseStatus> compareByDate = Comparator.comparing(TelemetryLicenseStatus::expirationDate).reversed();
        return telemetryLicenseStatuses1.stream().min(compareIsValid.thenComparing(compareIsExpired).thenComparing(compareByDate)).map(List::of).orElse(List.of());
    }

    private String formatLicenseString(TelemetryLicenseStatus telemetryLicenseStatus) {
        return telemetryLicenseStatus.subject().replace("/", ".").substring(1);
    }

    private Map<String, Object> flatten(Object o) {
        try {
            return JsonFlattener.flattenAsMap((String)this.objectMapper.writeValueAsString(o));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(StringUtils.f("Couldn't serialize %s!", o), e);
        }
    }
}

