/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.rest;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.hash.HashCode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.indexer.cluster.ClusterAdapter;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.storage.DetectedSearchVersion;
import org.graylog2.storage.SearchVersion;
import org.graylog2.system.stats.elasticsearch.NodeInfo;
import org.graylog2.system.traffic.TrafficCounterService;
import org.graylog2.telemetry.cluster.TelemetryClusterService;
import org.graylog2.telemetry.enterprise.TelemetryEnterpriseDataProvider;
import org.graylog2.telemetry.enterprise.TelemetryLicenseStatus;
import org.graylog2.telemetry.rest.TelemetryResponseFactory;
import org.graylog2.telemetry.rest.TelemetryUserSettings;
import org.graylog2.telemetry.user.db.DBTelemetryUserSettingsService;
import org.graylog2.telemetry.user.db.TelemetryUserSettingsDto;
import org.graylog2.users.events.UserDeletedEvent;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryService {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryService.class);
    private final TrafficCounterService trafficCounterService;
    private final TelemetryEnterpriseDataProvider enterpriseDataProvider;
    private final UserService userService;
    private final Set<PluginMetaData> pluginMetaDataSet;
    private final ClusterAdapter elasticClusterAdapter;
    private final SearchVersion elasticsearchVersion;
    private final TelemetryResponseFactory telemetryResponseFactory;
    private final DBTelemetryUserSettingsService dbTelemetryUserSettingsService;
    private final boolean isTelemetryEnabled;
    private final TelemetryClusterService telemetryClusterService;

    @Inject
    public TelemetryService(@Named(value="telemetry_enabled") boolean isTelemetryEnabled, TrafficCounterService trafficCounterService, TelemetryEnterpriseDataProvider enterpriseDataProvider, UserService userService, Set<PluginMetaData> pluginMetaDataSet, ClusterAdapter elasticClusterAdapter, @DetectedSearchVersion SearchVersion elasticsearchVersion, TelemetryResponseFactory telemetryResponseFactory, DBTelemetryUserSettingsService dbTelemetryUserSettingsService, EventBus eventBus, TelemetryClusterService telemetryClusterService) {
        this.isTelemetryEnabled = isTelemetryEnabled;
        this.trafficCounterService = trafficCounterService;
        this.enterpriseDataProvider = enterpriseDataProvider;
        this.userService = userService;
        this.pluginMetaDataSet = pluginMetaDataSet;
        this.elasticClusterAdapter = elasticClusterAdapter;
        this.elasticsearchVersion = elasticsearchVersion;
        this.telemetryResponseFactory = telemetryResponseFactory;
        this.dbTelemetryUserSettingsService = dbTelemetryUserSettingsService;
        this.telemetryClusterService = telemetryClusterService;
        eventBus.register((Object)this);
    }

    public Map<String, Object> getTelemetryResponse(User currentUser) {
        TelemetryUserSettings telemetryUserSettings = this.getTelemetryUserSettings(currentUser);
        if (this.isTelemetryEnabled && telemetryUserSettings.telemetryEnabled().booleanValue()) {
            DateTime clusterCreationDate = this.telemetryClusterService.getClusterCreationDate().orElse(null);
            String clusterId = this.telemetryClusterService.getClusterId();
            List<TelemetryLicenseStatus> licenseStatuses = this.enterpriseDataProvider.licenseStatus();
            return this.telemetryResponseFactory.createTelemetryResponse(this.getClusterInfo(clusterId, clusterCreationDate, licenseStatuses), this.getUserInfo(currentUser, clusterId), this.getPluginInfo(), this.getSearchClusterInfo(), licenseStatuses, telemetryUserSettings);
        }
        return this.telemetryResponseFactory.createTelemetryDisabledResponse(telemetryUserSettings);
    }

    public TelemetryUserSettings getTelemetryUserSettings(User currentUser) {
        Optional<TelemetryUserSettingsDto> telemetryUserSettings = this.dbTelemetryUserSettingsService.findByUserId(currentUser.getId());
        return telemetryUserSettings.map(dto -> TelemetryUserSettings.builder().telemetryEnabled(this.isTelemetryEnabled && dto.telemetryEnabled() != false).telemetryPermissionAsked(dto.telemetryPermissionAsked()).build()).orElse(TelemetryUserSettings.builder().telemetryEnabled(this.isTelemetryEnabled).telemetryPermissionAsked(false).build());
    }

    public void saveUserSettings(User currentUser, TelemetryUserSettings telemetryUserSettings) {
        TelemetryUserSettingsDto.Builder builder = TelemetryUserSettingsDto.builder().userId(currentUser.getId()).telemetryEnabled(telemetryUserSettings.telemetryEnabled()).telemetryPermissionAsked(telemetryUserSettings.telemetryPermissionAsked());
        this.dbTelemetryUserSettingsService.findByUserId(currentUser.getId()).ifPresent(dto -> builder.id(dto.id()));
        this.dbTelemetryUserSettingsService.save(builder.build());
    }

    public void updateTelemetryClusterData() {
        this.telemetryClusterService.updateTelemetryClusterData();
    }

    public void deleteUserSettingsByUser(User currentUser) {
        this.deleteUserSettingsByUserId(currentUser.getId());
    }

    @Subscribe
    private void handleUserDeletedEvent(UserDeletedEvent event) {
        this.deleteUserSettingsByUserId(event.userId());
    }

    private void deleteUserSettingsByUserId(String userId) {
        this.dbTelemetryUserSettingsService.delete(userId);
    }

    private Map<String, Object> getUserInfo(User currentUser, String clusterId) {
        try {
            if (currentUser == null) {
                LOG.debug("Couldn't create user telemetry data, because no current user exists!");
                return null;
            }
            return this.telemetryResponseFactory.createUserInfo(this.generateUserHash(currentUser, clusterId), currentUser.isLocalAdmin(), currentUser.getRoleIds().size(), this.enterpriseDataProvider.teamsCount(currentUser.getId()));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.debug("Couldn't create user telemetry data, because user couldn't be hashed!", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> getClusterInfo(String clusterId, DateTime clusterCreationDate, List<TelemetryLicenseStatus> licenseStatuses) {
        return this.telemetryResponseFactory.createClusterInfo(clusterId, clusterCreationDate, this.telemetryClusterService.nodesTelemetryInfo(), this.getAverageLastMonthTraffic(), this.userService.loadAll().stream().filter(user -> !user.isServiceAccount()).count(), licenseStatuses.size());
    }

    private Map<String, Object> getPluginInfo() {
        boolean isEnterprisePluginInstalled = this.pluginMetaDataSet.stream().anyMatch(p -> "Graylog Enterprise".equals(p.getName()));
        List<String> plugins = this.pluginMetaDataSet.stream().map(p -> StringUtils.f("%s:%s", p.getName(), p.getVersion())).toList();
        return this.telemetryResponseFactory.createPluginInfo(isEnterprisePluginInstalled, plugins);
    }

    private long getAverageLastMonthTraffic() {
        return this.trafficCounterService.clusterTrafficOfLastDays(Duration.standardDays((long)30L), TrafficCounterService.Interval.DAILY).output().values().stream().mapToLong(Long::longValue).sum();
    }

    private String generateUserHash(User currentUser, String clusterId) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(StringUtils.f("%s%s", currentUser.getId(), clusterId).getBytes(StandardCharsets.UTF_8));
        return HashCode.fromBytes((byte[])messageDigest.digest()).toString();
    }

    private Map<String, Object> getSearchClusterInfo() {
        Map<String, NodeInfo> nodesInfo = this.elasticClusterAdapter.nodesInfo();
        return this.telemetryResponseFactory.createSearchClusterInfo(nodesInfo.size(), this.elasticsearchVersion.toString(), nodesInfo);
    }
}

