package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NotificationEntity extends NotificationEntity {

  private final ValueReference title;

  private final ValueReference description;

  private final EventNotificationConfigEntity config;

  private AutoValue_NotificationEntity(
      ValueReference title,
      ValueReference description,
      EventNotificationConfigEntity config) {
    this.title = title;
    this.description = description;
    this.config = config;
  }

  @JsonProperty("title")
  @Override
  public ValueReference title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public ValueReference description() {
    return description;
  }

  @JsonProperty("config")
  @Override
  public EventNotificationConfigEntity config() {
    return config;
  }

  @Override
  public String toString() {
    return "NotificationEntity{"
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "config=" + config
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NotificationEntity) {
      NotificationEntity that = (NotificationEntity) o;
      return this.title.equals(that.title())
          && this.description.equals(that.description())
          && this.config.equals(that.config());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    return h$;
  }

  @Override
  public NotificationEntity.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends NotificationEntity.Builder {
    private ValueReference title;
    private ValueReference description;
    private EventNotificationConfigEntity config;
    Builder() {
    }
    private Builder(NotificationEntity source) {
      this.title = source.title();
      this.description = source.description();
      this.config = source.config();
    }
    @Override
    public NotificationEntity.Builder title(ValueReference title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public NotificationEntity.Builder description(ValueReference description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public NotificationEntity.Builder config(EventNotificationConfigEntity config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public NotificationEntity build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_NotificationEntity(
          this.title,
          this.description,
          this.config);
    }
  }

}
