package org.graylog.events.processor.systemnotification;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.graylog2.notifications.Notification;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SystemNotificationEventProcessorParameters extends SystemNotificationEventProcessorParameters {

  private final String type;

  private final DateTime timestamp;

  private final Notification.Type notificationType;

  private final String notificationMessage;

  private final Map<String, Object> notificationDetails;

  private AutoValue_SystemNotificationEventProcessorParameters(
      String type,
      DateTime timestamp,
      Notification.Type notificationType,
      String notificationMessage,
      Map<String, Object> notificationDetails) {
    this.type = type;
    this.timestamp = timestamp;
    this.notificationType = notificationType;
    this.notificationMessage = notificationMessage;
    this.notificationDetails = notificationDetails;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("timestamp")
  @Override
  public DateTime timestamp() {
    return timestamp;
  }

  @JsonProperty("notification_type")
  @Override
  public Notification.Type notificationType() {
    return notificationType;
  }

  @JsonProperty("notification_message")
  @Override
  public String notificationMessage() {
    return notificationMessage;
  }

  @JsonProperty("notification_details")
  @Override
  public Map<String, Object> notificationDetails() {
    return notificationDetails;
  }

  @Override
  public String toString() {
    return "SystemNotificationEventProcessorParameters{"
        + "type=" + type + ", "
        + "timestamp=" + timestamp + ", "
        + "notificationType=" + notificationType + ", "
        + "notificationMessage=" + notificationMessage + ", "
        + "notificationDetails=" + notificationDetails
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SystemNotificationEventProcessorParameters) {
      SystemNotificationEventProcessorParameters that = (SystemNotificationEventProcessorParameters) o;
      return this.type.equals(that.type())
          && this.timestamp.equals(that.timestamp())
          && this.notificationType.equals(that.notificationType())
          && this.notificationMessage.equals(that.notificationMessage())
          && this.notificationDetails.equals(that.notificationDetails());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= notificationType.hashCode();
    h$ *= 1000003;
    h$ ^= notificationMessage.hashCode();
    h$ *= 1000003;
    h$ ^= notificationDetails.hashCode();
    return h$;
  }

  @Override
  public SystemNotificationEventProcessorParameters.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends SystemNotificationEventProcessorParameters.Builder {
    private String type;
    private DateTime timestamp;
    private Notification.Type notificationType;
    private String notificationMessage;
    private Map<String, Object> notificationDetails;
    Builder() {
    }
    private Builder(SystemNotificationEventProcessorParameters source) {
      this.type = source.type();
      this.timestamp = source.timestamp();
      this.notificationType = source.notificationType();
      this.notificationMessage = source.notificationMessage();
      this.notificationDetails = source.notificationDetails();
    }
    @Override
    public SystemNotificationEventProcessorParameters.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public SystemNotificationEventProcessorParameters.Builder timestamp(DateTime timestamp) {
      if (timestamp == null) {
        throw new NullPointerException("Null timestamp");
      }
      this.timestamp = timestamp;
      return this;
    }
    @Override
    public SystemNotificationEventProcessorParameters.Builder notificationType(Notification.Type notificationType) {
      if (notificationType == null) {
        throw new NullPointerException("Null notificationType");
      }
      this.notificationType = notificationType;
      return this;
    }
    @Override
    public SystemNotificationEventProcessorParameters.Builder notificationMessage(String notificationMessage) {
      if (notificationMessage == null) {
        throw new NullPointerException("Null notificationMessage");
      }
      this.notificationMessage = notificationMessage;
      return this;
    }
    @Override
    public SystemNotificationEventProcessorParameters.Builder notificationDetails(Map<String, Object> notificationDetails) {
      if (notificationDetails == null) {
        throw new NullPointerException("Null notificationDetails");
      }
      this.notificationDetails = notificationDetails;
      return this;
    }
    @Override
    public SystemNotificationEventProcessorParameters build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.timestamp == null) {
        missing += " timestamp";
      }
      if (this.notificationType == null) {
        missing += " notificationType";
      }
      if (this.notificationMessage == null) {
        missing += " notificationMessage";
      }
      if (this.notificationDetails == null) {
        missing += " notificationDetails";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SystemNotificationEventProcessorParameters(
          this.type,
          this.timestamp,
          this.notificationType,
          this.notificationMessage,
          this.notificationDetails);
    }
  }

}
