package org.graylog.plugins.netflow.v5;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NetFlowV5Packet extends NetFlowV5Packet {

  private final NetFlowV5Header header;

  private final ImmutableList<NetFlowV5Record> records;

  private final long dataLength;

  AutoValue_NetFlowV5Packet(
      NetFlowV5Header header,
      ImmutableList<NetFlowV5Record> records,
      long dataLength) {
    if (header == null) {
      throw new NullPointerException("Null header");
    }
    this.header = header;
    if (records == null) {
      throw new NullPointerException("Null records");
    }
    this.records = records;
    this.dataLength = dataLength;
  }

  @Override
  public NetFlowV5Header header() {
    return header;
  }

  @Override
  public ImmutableList<NetFlowV5Record> records() {
    return records;
  }

  @Override
  public long dataLength() {
    return dataLength;
  }

  @Override
  public String toString() {
    return "NetFlowV5Packet{"
        + "header=" + header + ", "
        + "records=" + records + ", "
        + "dataLength=" + dataLength
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NetFlowV5Packet) {
      NetFlowV5Packet that = (NetFlowV5Packet) o;
      return this.header.equals(that.header())
          && this.records.equals(that.records())
          && this.dataLength == that.dataLength();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= header.hashCode();
    h$ *= 1000003;
    h$ ^= records.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((dataLength >>> 32) ^ dataLength);
    return h$;
  }

}
