package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PipelineConnections extends PipelineConnections {

  private final String id;

  private final String streamId;

  private final Set<String> pipelineIds;

  private AutoValue_PipelineConnections(
      @Nullable String id,
      String streamId,
      Set<String> pipelineIds) {
    this.id = id;
    this.streamId = streamId;
    this.pipelineIds = pipelineIds;
  }

  @JsonProperty("id")
  @Nullable
  @Id
  @ObjectId
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public String streamId() {
    return streamId;
  }

  @JsonProperty
  @Override
  public Set<String> pipelineIds() {
    return pipelineIds;
  }

  @Override
  public String toString() {
    return "PipelineConnections{"
        + "id=" + id + ", "
        + "streamId=" + streamId + ", "
        + "pipelineIds=" + pipelineIds
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PipelineConnections) {
      PipelineConnections that = (PipelineConnections) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.streamId.equals(that.streamId())
          && this.pipelineIds.equals(that.pipelineIds());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= streamId.hashCode();
    h$ *= 1000003;
    h$ ^= pipelineIds.hashCode();
    return h$;
  }

  @Override
  public PipelineConnections.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends PipelineConnections.Builder {
    private String id;
    private String streamId;
    private Set<String> pipelineIds;
    Builder() {
    }
    private Builder(PipelineConnections source) {
      this.id = source.id();
      this.streamId = source.streamId();
      this.pipelineIds = source.pipelineIds();
    }
    @Override
    public PipelineConnections.Builder id(String id) {
      this.id = id;
      return this;
    }
    @Override
    public PipelineConnections.Builder streamId(String streamId) {
      if (streamId == null) {
        throw new NullPointerException("Null streamId");
      }
      this.streamId = streamId;
      return this;
    }
    @Override
    public PipelineConnections.Builder pipelineIds(Set<String> pipelineIds) {
      if (pipelineIds == null) {
        throw new NullPointerException("Null pipelineIds");
      }
      this.pipelineIds = pipelineIds;
      return this;
    }
    @Override
    public PipelineConnections build() {
      String missing = "";
      if (this.streamId == null) {
        missing += " streamId";
      }
      if (this.pipelineIds == null) {
        missing += " pipelineIds";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_PipelineConnections(
          this.id,
          this.streamId,
          this.pipelineIds);
    }
  }

}
