package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.processing.Generated;
import org.graylog.plugins.pipelineprocessor.simulator.PipelineInterpreterTrace;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SimulationResponse extends SimulationResponse {

  private final List<ResultMessageSummary> messages;

  private final List<PipelineInterpreterTrace> simulationTrace;

  private final long tookMicroseconds;

  private AutoValue_SimulationResponse(
      List<ResultMessageSummary> messages,
      List<PipelineInterpreterTrace> simulationTrace,
      long tookMicroseconds) {
    this.messages = messages;
    this.simulationTrace = simulationTrace;
    this.tookMicroseconds = tookMicroseconds;
  }

  @JsonProperty
  @Override
  public List<ResultMessageSummary> messages() {
    return messages;
  }

  @JsonProperty
  @Override
  public List<PipelineInterpreterTrace> simulationTrace() {
    return simulationTrace;
  }

  @JsonProperty
  @Override
  public long tookMicroseconds() {
    return tookMicroseconds;
  }

  @Override
  public String toString() {
    return "SimulationResponse{"
        + "messages=" + messages + ", "
        + "simulationTrace=" + simulationTrace + ", "
        + "tookMicroseconds=" + tookMicroseconds
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SimulationResponse) {
      SimulationResponse that = (SimulationResponse) o;
      return this.messages.equals(that.messages())
          && this.simulationTrace.equals(that.simulationTrace())
          && this.tookMicroseconds == that.tookMicroseconds();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= messages.hashCode();
    h$ *= 1000003;
    h$ ^= simulationTrace.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((tookMicroseconds >>> 32) ^ tookMicroseconds);
    return h$;
  }

  static final class Builder extends SimulationResponse.Builder {
    private List<ResultMessageSummary> messages;
    private List<PipelineInterpreterTrace> simulationTrace;
    private Long tookMicroseconds;
    Builder() {
    }
    @Override
    public SimulationResponse.Builder messages(List<ResultMessageSummary> messages) {
      if (messages == null) {
        throw new NullPointerException("Null messages");
      }
      this.messages = messages;
      return this;
    }
    @Override
    public SimulationResponse.Builder simulationTrace(List<PipelineInterpreterTrace> simulationTrace) {
      if (simulationTrace == null) {
        throw new NullPointerException("Null simulationTrace");
      }
      this.simulationTrace = simulationTrace;
      return this;
    }
    @Override
    public SimulationResponse.Builder tookMicroseconds(long tookMicroseconds) {
      this.tookMicroseconds = tookMicroseconds;
      return this;
    }
    @Override
    public SimulationResponse build() {
      String missing = "";
      if (this.messages == null) {
        missing += " messages";
      }
      if (this.simulationTrace == null) {
        missing += " simulationTrace";
      }
      if (this.tookMicroseconds == null) {
        missing += " tookMicroseconds";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SimulationResponse(
          this.messages,
          this.simulationTrace,
          this.tookMicroseconds);
    }
  }

}
