package org.graylog.plugins.pipelineprocessor.rest;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.processing.Generated;
import javax.validation.constraints.Min;
import org.graylog.plugins.pipelineprocessor.ast.Stage;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_StageSource extends StageSource {

  private final @Min(0L) int stage;

  private final Stage.Match match;

  private final List<String> rules;

  private AutoValue_StageSource(
      @Min(0L) int stage,
      Stage.Match match,
      List<String> rules) {
    this.stage = stage;
    this.match = match;
    this.rules = rules;
  }

  @JsonProperty("stage")
  @Override
  public @Min(0L) int stage() {
    return stage;
  }

  @JsonProperty("match")
  @Override
  public Stage.Match match() {
    return match;
  }

  @JsonProperty("rules")
  @Override
  public List<String> rules() {
    return rules;
  }

  @Override
  public String toString() {
    return "StageSource{"
        + "stage=" + stage + ", "
        + "match=" + match + ", "
        + "rules=" + rules
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof StageSource) {
      StageSource that = (StageSource) o;
      return this.stage == that.stage()
          && this.match.equals(that.match())
          && this.rules.equals(that.rules());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= stage;
    h$ *= 1000003;
    h$ ^= match.hashCode();
    h$ *= 1000003;
    h$ ^= rules.hashCode();
    return h$;
  }

  @Override
  public StageSource.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends StageSource.Builder {
    private Integer stage;
    private Stage.Match match;
    private List<String> rules;
    Builder() {
    }
    private Builder(StageSource source) {
      this.stage = source.stage();
      this.match = source.match();
      this.rules = source.rules();
    }
    @Override
    public StageSource.Builder stage(int stage) {
      this.stage = stage;
      return this;
    }
    @Override
    public StageSource.Builder match(Stage.Match match) {
      if (match == null) {
        throw new NullPointerException("Null match");
      }
      this.match = match;
      return this;
    }
    @Override
    public StageSource.Builder rules(List<String> rules) {
      if (rules == null) {
        throw new NullPointerException("Null rules");
      }
      this.rules = rules;
      return this;
    }
    @Override
    public StageSource build() {
      String missing = "";
      if (this.stage == null) {
        missing += " stage";
      }
      if (this.match == null) {
        missing += " match";
      }
      if (this.rules == null) {
        missing += " rules";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_StageSource(
          this.stage,
          this.match,
          this.rules);
    }
  }

}
