package org.graylog.plugins.threatintel.adapters.otx;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_OTXDataAdapter_Config extends OTXDataAdapter.Config {

  private final String type;

  private final @NotEmpty String indicator;

  private final String apiKey;

  private final @NotEmpty String apiUrl;

  private final @NotEmpty String httpUserAgent;

  private final @Min(1L) long httpConnectTimeout;

  private final @Min(1L) long httpWriteTimeout;

  private final @Min(1L) long httpReadTimeout;

  $AutoValue_OTXDataAdapter_Config(
      String type,
      @NotEmpty String indicator,
      @Nullable String apiKey,
      @NotEmpty String apiUrl,
      @NotEmpty String httpUserAgent,
      @Min(1L) long httpConnectTimeout,
      @Min(1L) long httpWriteTimeout,
      @Min(1L) long httpReadTimeout) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (indicator == null) {
      throw new NullPointerException("Null indicator");
    }
    this.indicator = indicator;
    this.apiKey = apiKey;
    if (apiUrl == null) {
      throw new NullPointerException("Null apiUrl");
    }
    this.apiUrl = apiUrl;
    if (httpUserAgent == null) {
      throw new NullPointerException("Null httpUserAgent");
    }
    this.httpUserAgent = httpUserAgent;
    this.httpConnectTimeout = httpConnectTimeout;
    this.httpWriteTimeout = httpWriteTimeout;
    this.httpReadTimeout = httpReadTimeout;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("indicator")
  @Override
  public @NotEmpty String indicator() {
    return indicator;
  }

  @JsonProperty("api_key")
  @Nullable
  @Override
  public String apiKey() {
    return apiKey;
  }

  @JsonProperty("api_url")
  @Override
  public @NotEmpty String apiUrl() {
    return apiUrl;
  }

  @JsonProperty("http_user_agent")
  @Override
  public @NotEmpty String httpUserAgent() {
    return httpUserAgent;
  }

  @JsonProperty("http_connect_timeout")
  @Override
  public @Min(1L) long httpConnectTimeout() {
    return httpConnectTimeout;
  }

  @JsonProperty("http_write_timeout")
  @Override
  public @Min(1L) long httpWriteTimeout() {
    return httpWriteTimeout;
  }

  @JsonProperty("http_read_timeout")
  @Override
  public @Min(1L) long httpReadTimeout() {
    return httpReadTimeout;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "indicator=" + indicator + ", "
        + "apiKey=" + apiKey + ", "
        + "apiUrl=" + apiUrl + ", "
        + "httpUserAgent=" + httpUserAgent + ", "
        + "httpConnectTimeout=" + httpConnectTimeout + ", "
        + "httpWriteTimeout=" + httpWriteTimeout + ", "
        + "httpReadTimeout=" + httpReadTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof OTXDataAdapter.Config) {
      OTXDataAdapter.Config that = (OTXDataAdapter.Config) o;
      return this.type.equals(that.type())
          && this.indicator.equals(that.indicator())
          && (this.apiKey == null ? that.apiKey() == null : this.apiKey.equals(that.apiKey()))
          && this.apiUrl.equals(that.apiUrl())
          && this.httpUserAgent.equals(that.httpUserAgent())
          && this.httpConnectTimeout == that.httpConnectTimeout()
          && this.httpWriteTimeout == that.httpWriteTimeout()
          && this.httpReadTimeout == that.httpReadTimeout();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= indicator.hashCode();
    h$ *= 1000003;
    h$ ^= (apiKey == null) ? 0 : apiKey.hashCode();
    h$ *= 1000003;
    h$ ^= apiUrl.hashCode();
    h$ *= 1000003;
    h$ ^= httpUserAgent.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((httpConnectTimeout >>> 32) ^ httpConnectTimeout);
    h$ *= 1000003;
    h$ ^= (int) ((httpWriteTimeout >>> 32) ^ httpWriteTimeout);
    h$ *= 1000003;
    h$ ^= (int) ((httpReadTimeout >>> 32) ^ httpReadTimeout);
    return h$;
  }

  @Override
  public OTXDataAdapter.Config.Builder toBuilder() {
    return new Builder(this);
  }

  static class Builder extends OTXDataAdapter.Config.Builder {
    private String type;
    private @NotEmpty String indicator;
    private String apiKey;
    private @NotEmpty String apiUrl;
    private @NotEmpty String httpUserAgent;
    private Long httpConnectTimeout;
    private Long httpWriteTimeout;
    private Long httpReadTimeout;
    Builder() {
    }
    private Builder(OTXDataAdapter.Config source) {
      this.type = source.type();
      this.indicator = source.indicator();
      this.apiKey = source.apiKey();
      this.apiUrl = source.apiUrl();
      this.httpUserAgent = source.httpUserAgent();
      this.httpConnectTimeout = source.httpConnectTimeout();
      this.httpWriteTimeout = source.httpWriteTimeout();
      this.httpReadTimeout = source.httpReadTimeout();
    }
    @Override
    public OTXDataAdapter.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder indicator(String indicator) {
      if (indicator == null) {
        throw new NullPointerException("Null indicator");
      }
      this.indicator = indicator;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder apiKey(String apiKey) {
      this.apiKey = apiKey;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder apiUrl(String apiUrl) {
      if (apiUrl == null) {
        throw new NullPointerException("Null apiUrl");
      }
      this.apiUrl = apiUrl;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder httpUserAgent(String httpUserAgent) {
      if (httpUserAgent == null) {
        throw new NullPointerException("Null httpUserAgent");
      }
      this.httpUserAgent = httpUserAgent;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder httpConnectTimeout(long httpConnectTimeout) {
      this.httpConnectTimeout = httpConnectTimeout;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder httpWriteTimeout(long httpWriteTimeout) {
      this.httpWriteTimeout = httpWriteTimeout;
      return this;
    }
    @Override
    public OTXDataAdapter.Config.Builder httpReadTimeout(long httpReadTimeout) {
      this.httpReadTimeout = httpReadTimeout;
      return this;
    }
    @Override
    public OTXDataAdapter.Config build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.indicator == null) {
        missing += " indicator";
      }
      if (this.apiUrl == null) {
        missing += " apiUrl";
      }
      if (this.httpUserAgent == null) {
        missing += " httpUserAgent";
      }
      if (this.httpConnectTimeout == null) {
        missing += " httpConnectTimeout";
      }
      if (this.httpWriteTimeout == null) {
        missing += " httpWriteTimeout";
      }
      if (this.httpReadTimeout == null) {
        missing += " httpReadTimeout";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_OTXDataAdapter_Config(
          this.type,
          this.indicator,
          this.apiKey,
          this.apiUrl,
          this.httpUserAgent,
          this.httpConnectTimeout,
          this.httpWriteTimeout,
          this.httpReadTimeout);
    }
  }

}
