package org.graylog.plugins.views.search.export;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.decorators.Decorator;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTimeZone;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ExportMessagesCommand extends ExportMessagesCommand {

  private final AbsoluteRange timeRange;

  private final ElasticsearchQueryString queryString;

  private final Set<String> streams;

  private final Collection<UsedSearchFilter> usedSearchFilters;

  private final LinkedHashSet<String> fieldsInOrder;

  private final List<Decorator> decorators;

  private final int chunkSize;

  private final OptionalInt limit;

  private final DateTimeZone timeZone;

  private AutoValue_ExportMessagesCommand(
      AbsoluteRange timeRange,
      ElasticsearchQueryString queryString,
      Set<String> streams,
      Collection<UsedSearchFilter> usedSearchFilters,
      LinkedHashSet<String> fieldsInOrder,
      List<Decorator> decorators,
      int chunkSize,
      OptionalInt limit,
      DateTimeZone timeZone) {
    this.timeRange = timeRange;
    this.queryString = queryString;
    this.streams = streams;
    this.usedSearchFilters = usedSearchFilters;
    this.fieldsInOrder = fieldsInOrder;
    this.decorators = decorators;
    this.chunkSize = chunkSize;
    this.limit = limit;
    this.timeZone = timeZone;
  }

  @Override
  public AbsoluteRange timeRange() {
    return timeRange;
  }

  @Override
  public ElasticsearchQueryString queryString() {
    return queryString;
  }

  @Override
  public Set<String> streams() {
    return streams;
  }

  @Override
  public Collection<UsedSearchFilter> usedSearchFilters() {
    return usedSearchFilters;
  }

  @Override
  public LinkedHashSet<String> fieldsInOrder() {
    return fieldsInOrder;
  }

  @Override
  public List<Decorator> decorators() {
    return decorators;
  }

  @Override
  public int chunkSize() {
    return chunkSize;
  }

  @Override
  public OptionalInt limit() {
    return limit;
  }

  @Override
  public DateTimeZone timeZone() {
    return timeZone;
  }

  @Override
  public String toString() {
    return "ExportMessagesCommand{"
        + "timeRange=" + timeRange + ", "
        + "queryString=" + queryString + ", "
        + "streams=" + streams + ", "
        + "usedSearchFilters=" + usedSearchFilters + ", "
        + "fieldsInOrder=" + fieldsInOrder + ", "
        + "decorators=" + decorators + ", "
        + "chunkSize=" + chunkSize + ", "
        + "limit=" + limit + ", "
        + "timeZone=" + timeZone
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExportMessagesCommand) {
      ExportMessagesCommand that = (ExportMessagesCommand) o;
      return this.timeRange.equals(that.timeRange())
          && this.queryString.equals(that.queryString())
          && this.streams.equals(that.streams())
          && this.usedSearchFilters.equals(that.usedSearchFilters())
          && this.fieldsInOrder.equals(that.fieldsInOrder())
          && this.decorators.equals(that.decorators())
          && this.chunkSize == that.chunkSize()
          && this.limit.equals(that.limit())
          && this.timeZone.equals(that.timeZone());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= timeRange.hashCode();
    h$ *= 1000003;
    h$ ^= queryString.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= usedSearchFilters.hashCode();
    h$ *= 1000003;
    h$ ^= fieldsInOrder.hashCode();
    h$ *= 1000003;
    h$ ^= decorators.hashCode();
    h$ *= 1000003;
    h$ ^= chunkSize;
    h$ *= 1000003;
    h$ ^= limit.hashCode();
    h$ *= 1000003;
    h$ ^= timeZone.hashCode();
    return h$;
  }

  @Override
  public ExportMessagesCommand.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ExportMessagesCommand.Builder {
    private AbsoluteRange timeRange;
    private ElasticsearchQueryString queryString;
    private Set<String> streams;
    private Collection<UsedSearchFilter> usedSearchFilters;
    private LinkedHashSet<String> fieldsInOrder;
    private List<Decorator> decorators;
    private Integer chunkSize;
    private OptionalInt limit = OptionalInt.empty();
    private DateTimeZone timeZone;
    Builder() {
    }
    private Builder(ExportMessagesCommand source) {
      this.timeRange = source.timeRange();
      this.queryString = source.queryString();
      this.streams = source.streams();
      this.usedSearchFilters = source.usedSearchFilters();
      this.fieldsInOrder = source.fieldsInOrder();
      this.decorators = source.decorators();
      this.chunkSize = source.chunkSize();
      this.limit = source.limit();
      this.timeZone = source.timeZone();
    }
    @Override
    public ExportMessagesCommand.Builder timeRange(AbsoluteRange timeRange) {
      if (timeRange == null) {
        throw new NullPointerException("Null timeRange");
      }
      this.timeRange = timeRange;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder queryString(ElasticsearchQueryString queryString) {
      if (queryString == null) {
        throw new NullPointerException("Null queryString");
      }
      this.queryString = queryString;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder streams(Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder usedSearchFilters(Collection<UsedSearchFilter> usedSearchFilters) {
      if (usedSearchFilters == null) {
        throw new NullPointerException("Null usedSearchFilters");
      }
      this.usedSearchFilters = usedSearchFilters;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder fieldsInOrder(LinkedHashSet<String> fieldsInOrder) {
      if (fieldsInOrder == null) {
        throw new NullPointerException("Null fieldsInOrder");
      }
      this.fieldsInOrder = fieldsInOrder;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder decorators(List<Decorator> decorators) {
      if (decorators == null) {
        throw new NullPointerException("Null decorators");
      }
      this.decorators = decorators;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder chunkSize(int chunkSize) {
      this.chunkSize = chunkSize;
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder limit(Integer limit) {
      this.limit = OptionalInt.of(limit);
      return this;
    }
    @Override
    public ExportMessagesCommand.Builder timeZone(DateTimeZone timeZone) {
      if (timeZone == null) {
        throw new NullPointerException("Null timeZone");
      }
      this.timeZone = timeZone;
      return this;
    }
    @Override
    ExportMessagesCommand autoBuild() {
      String missing = "";
      if (this.timeRange == null) {
        missing += " timeRange";
      }
      if (this.queryString == null) {
        missing += " queryString";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.usedSearchFilters == null) {
        missing += " usedSearchFilters";
      }
      if (this.fieldsInOrder == null) {
        missing += " fieldsInOrder";
      }
      if (this.decorators == null) {
        missing += " decorators";
      }
      if (this.chunkSize == null) {
        missing += " chunkSize";
      }
      if (this.timeZone == null) {
        missing += " timeZone";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExportMessagesCommand(
          this.timeRange,
          this.queryString,
          this.streams,
          this.usedSearchFilters,
          this.fieldsInOrder,
          this.decorators,
          this.chunkSize,
          this.limit,
          this.timeZone);
    }
  }

}
