package org.graylog.plugins.views.search.rest.suggestions;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_SuggestionsRequestDTO extends SuggestionsRequestDTO {

  private final String field;

  private final String input;

  private final int size;

  private final TimeRange timerange;

  private final Set<String> streams;

  private AutoValue_SuggestionsRequestDTO(
      String field,
      String input,
      int size,
      @Nullable TimeRange timerange,
      @Nullable Set<String> streams) {
    this.field = field;
    this.input = input;
    this.size = size;
    this.timerange = timerange;
    this.streams = streams;
  }

  @JsonProperty
  @Override
  public String field() {
    return field;
  }

  @JsonProperty
  @Override
  public String input() {
    return input;
  }

  @JsonProperty
  @Override
  public int size() {
    return size;
  }

  @Nullable
  @JsonProperty("timerange")
  @Override
  public TimeRange timerange() {
    return timerange;
  }

  @Nullable
  @JsonProperty("streams")
  @Override
  public Set<String> streams() {
    return streams;
  }

  @Override
  public String toString() {
    return "SuggestionsRequestDTO{"
        + "field=" + field + ", "
        + "input=" + input + ", "
        + "size=" + size + ", "
        + "timerange=" + timerange + ", "
        + "streams=" + streams
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SuggestionsRequestDTO) {
      SuggestionsRequestDTO that = (SuggestionsRequestDTO) o;
      return this.field.equals(that.field())
          && this.input.equals(that.input())
          && this.size == that.size()
          && (this.timerange == null ? that.timerange() == null : this.timerange.equals(that.timerange()))
          && (this.streams == null ? that.streams() == null : this.streams.equals(that.streams()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= field.hashCode();
    h$ *= 1000003;
    h$ ^= input.hashCode();
    h$ *= 1000003;
    h$ ^= size;
    h$ *= 1000003;
    h$ ^= (timerange == null) ? 0 : timerange.hashCode();
    h$ *= 1000003;
    h$ ^= (streams == null) ? 0 : streams.hashCode();
    return h$;
  }

  static final class Builder extends SuggestionsRequestDTO.Builder {
    private String field;
    private String input;
    private Integer size;
    private TimeRange timerange;
    private Set<String> streams;
    Builder() {
    }
    @Override
    public SuggestionsRequestDTO.Builder field(String field) {
      if (field == null) {
        throw new NullPointerException("Null field");
      }
      this.field = field;
      return this;
    }
    @Override
    public SuggestionsRequestDTO.Builder input(String input) {
      if (input == null) {
        throw new NullPointerException("Null input");
      }
      this.input = input;
      return this;
    }
    @Override
    public SuggestionsRequestDTO.Builder size(int size) {
      this.size = size;
      return this;
    }
    @Override
    public SuggestionsRequestDTO.Builder timerange(@Nullable TimeRange timerange) {
      this.timerange = timerange;
      return this;
    }
    @Override
    public SuggestionsRequestDTO.Builder streams(@Nullable Set<String> streams) {
      this.streams = streams;
      return this;
    }
    @Override
    public SuggestionsRequestDTO build() {
      String missing = "";
      if (this.field == null) {
        missing += " field";
      }
      if (this.input == null) {
        missing += " input";
      }
      if (this.size == null) {
        missing += " size";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_SuggestionsRequestDTO(
          this.field,
          this.input,
          this.size,
          this.timerange,
          this.streams);
    }
  }

}
