package org.graylog.plugins.views.search.searchfilters.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_InlineQueryStringSearchFilter extends InlineQueryStringSearchFilter {

  private final String title;

  private final Optional<String> id;

  private final String description;

  private final String queryString;

  private final boolean negation;

  private final boolean disabled;

  private AutoValue_InlineQueryStringSearchFilter(
      @Nullable String title,
      Optional<String> id,
      @Nullable String description,
      String queryString,
      boolean negation,
      boolean disabled) {
    this.title = title;
    this.id = id;
    this.description = description;
    this.queryString = queryString;
    this.negation = negation;
    this.disabled = disabled;
  }

  @JsonProperty("title")
  @Nullable
  @Override
  public String title() {
    return title;
  }

  @JsonProperty("id")
  @JsonInclude(JsonInclude.Include.NON_ABSENT)
  @Override
  public Optional<String> id() {
    return id;
  }

  @JsonProperty("description")
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty("queryString")
  @Override
  public String queryString() {
    return queryString;
  }

  @JsonProperty(value = "negation", defaultValue = "false")
  @Override
  public boolean negation() {
    return negation;
  }

  @JsonProperty(value = "disabled", defaultValue = "false")
  @Override
  public boolean disabled() {
    return disabled;
  }

  @Override
  public String toString() {
    return "InlineQueryStringSearchFilter{"
        + "title=" + title + ", "
        + "id=" + id + ", "
        + "description=" + description + ", "
        + "queryString=" + queryString + ", "
        + "negation=" + negation + ", "
        + "disabled=" + disabled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof InlineQueryStringSearchFilter) {
      InlineQueryStringSearchFilter that = (InlineQueryStringSearchFilter) o;
      return (this.title == null ? that.title() == null : this.title.equals(that.title()))
          && this.id.equals(that.id())
          && (this.description == null ? that.description() == null : this.description.equals(that.description()))
          && this.queryString.equals(that.queryString())
          && this.negation == that.negation()
          && this.disabled == that.disabled();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (title == null) ? 0 : title.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= (description == null) ? 0 : description.hashCode();
    h$ *= 1000003;
    h$ ^= queryString.hashCode();
    h$ *= 1000003;
    h$ ^= negation ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= disabled ? 1231 : 1237;
    return h$;
  }

  @Override
  public InlineQueryStringSearchFilter.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends InlineQueryStringSearchFilter.Builder {
    private String title;
    private Optional<String> id = Optional.empty();
    private String description;
    private String queryString;
    private Boolean negation;
    private Boolean disabled;
    Builder() {
    }
    private Builder(InlineQueryStringSearchFilter source) {
      this.title = source.title();
      this.id = source.id();
      this.description = source.description();
      this.queryString = source.queryString();
      this.negation = source.negation();
      this.disabled = source.disabled();
    }
    @Override
    public InlineQueryStringSearchFilter.Builder title(String title) {
      this.title = title;
      return this;
    }
    @Override
    public InlineQueryStringSearchFilter.Builder id(@Nullable String id) {
      this.id = Optional.ofNullable(id);
      return this;
    }
    @Override
    public InlineQueryStringSearchFilter.Builder description(String description) {
      this.description = description;
      return this;
    }
    @Override
    public InlineQueryStringSearchFilter.Builder queryString(String queryString) {
      if (queryString == null) {
        throw new NullPointerException("Null queryString");
      }
      this.queryString = queryString;
      return this;
    }
    @Override
    public InlineQueryStringSearchFilter.Builder negation(boolean negation) {
      this.negation = negation;
      return this;
    }
    @Override
    public InlineQueryStringSearchFilter.Builder disabled(boolean disabled) {
      this.disabled = disabled;
      return this;
    }
    @Override
    public InlineQueryStringSearchFilter build() {
      String missing = "";
      if (this.queryString == null) {
        missing += " queryString";
      }
      if (this.negation == null) {
        missing += " negation";
      }
      if (this.disabled == null) {
        missing += " disabled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_InlineQueryStringSearchFilter(
          this.title,
          this.id,
          this.description,
          this.queryString,
          this.negation,
          this.disabled);
    }
  }

}
