package org.graylog.plugins.views.search.searchtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.rest.models.messages.responses.DecorationStats;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MessageList_Result extends MessageList.Result {

  private final Optional<String> name;

  private final String id;

  private final List<ResultMessageSummary> messages;

  private final Optional<DecorationStats> decorationStats;

  private final AbsoluteRange effectiveTimerange;

  private final long totalResults;

  private AutoValue_MessageList_Result(
      Optional<String> name,
      String id,
      List<ResultMessageSummary> messages,
      Optional<DecorationStats> decorationStats,
      AbsoluteRange effectiveTimerange,
      long totalResults) {
    this.name = name;
    this.id = id;
    this.messages = messages;
    this.decorationStats = decorationStats;
    this.effectiveTimerange = effectiveTimerange;
    this.totalResults = totalResults;
  }

  @JsonProperty
  @Override
  public Optional<String> name() {
    return name;
  }

  @JsonProperty
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public List<ResultMessageSummary> messages() {
    return messages;
  }

  @JsonProperty
  @Override
  public Optional<DecorationStats> decorationStats() {
    return decorationStats;
  }

  @JsonProperty
  @Override
  public AbsoluteRange effectiveTimerange() {
    return effectiveTimerange;
  }

  @JsonProperty
  @Override
  public long totalResults() {
    return totalResults;
  }

  @Override
  public String toString() {
    return "Result{"
        + "name=" + name + ", "
        + "id=" + id + ", "
        + "messages=" + messages + ", "
        + "decorationStats=" + decorationStats + ", "
        + "effectiveTimerange=" + effectiveTimerange + ", "
        + "totalResults=" + totalResults
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MessageList.Result) {
      MessageList.Result that = (MessageList.Result) o;
      return this.name.equals(that.name())
          && this.id.equals(that.id())
          && this.messages.equals(that.messages())
          && this.decorationStats.equals(that.decorationStats())
          && this.effectiveTimerange.equals(that.effectiveTimerange())
          && this.totalResults == that.totalResults();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= id.hashCode();
    h$ *= 1000003;
    h$ ^= messages.hashCode();
    h$ *= 1000003;
    h$ ^= decorationStats.hashCode();
    h$ *= 1000003;
    h$ ^= effectiveTimerange.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((totalResults >>> 32) ^ totalResults);
    return h$;
  }

  static final class Builder extends MessageList.Result.Builder {
    private Optional<String> name = Optional.empty();
    private String id;
    private List<ResultMessageSummary> messages;
    private Optional<DecorationStats> decorationStats = Optional.empty();
    private AbsoluteRange effectiveTimerange;
    private Long totalResults;
    Builder() {
    }
    @Override
    public MessageList.Result.Builder name(@Nullable String name) {
      this.name = Optional.ofNullable(name);
      return this;
    }
    @Override
    public MessageList.Result.Builder id(String id) {
      if (id == null) {
        throw new NullPointerException("Null id");
      }
      this.id = id;
      return this;
    }
    @Override
    public MessageList.Result.Builder messages(List<ResultMessageSummary> messages) {
      if (messages == null) {
        throw new NullPointerException("Null messages");
      }
      this.messages = messages;
      return this;
    }
    @Override
    public MessageList.Result.Builder decorationStats(DecorationStats decorationStats) {
      this.decorationStats = Optional.of(decorationStats);
      return this;
    }
    @Override
    public MessageList.Result.Builder effectiveTimerange(AbsoluteRange effectiveTimerange) {
      if (effectiveTimerange == null) {
        throw new NullPointerException("Null effectiveTimerange");
      }
      this.effectiveTimerange = effectiveTimerange;
      return this;
    }
    @Override
    public MessageList.Result.Builder totalResults(long totalResults) {
      this.totalResults = totalResults;
      return this;
    }
    @Override
    public MessageList.Result build() {
      String missing = "";
      if (this.id == null) {
        missing += " id";
      }
      if (this.messages == null) {
        missing += " messages";
      }
      if (this.effectiveTimerange == null) {
        missing += " effectiveTimerange";
      }
      if (this.totalResults == null) {
        missing += " totalResults";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MessageList_Result(
          this.name,
          this.id,
          this.messages,
          this.decorationStats,
          this.effectiveTimerange,
          this.totalResults);
    }
  }

}
