package org.graylog.plugins.views.search.validation;

import com.google.common.collect.ImmutableList;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotNull;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ParsedQuery extends ParsedQuery {

  private final String query;

  private final ImmutableList<ParsedTerm> terms;

  private final ImmutableList<ImmutableToken> tokens;

  private AutoValue_ParsedQuery(
      String query,
      ImmutableList<ParsedTerm> terms,
      ImmutableList<ImmutableToken> tokens) {
    this.query = query;
    this.terms = terms;
    this.tokens = tokens;
  }

  @Override
  public String query() {
    return query;
  }

  @Override
  public ImmutableList<ParsedTerm> terms() {
    return terms;
  }

  @Override
  public ImmutableList<ImmutableToken> tokens() {
    return tokens;
  }

  @Override
  public String toString() {
    return "ParsedQuery{"
        + "query=" + query + ", "
        + "terms=" + terms + ", "
        + "tokens=" + tokens
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ParsedQuery) {
      ParsedQuery that = (ParsedQuery) o;
      return this.query.equals(that.query())
          && this.terms.equals(that.terms())
          && this.tokens.equals(that.tokens());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= terms.hashCode();
    h$ *= 1000003;
    h$ ^= tokens.hashCode();
    return h$;
  }

  static final class Builder extends ParsedQuery.Builder {
    private String query;
    private ImmutableList.Builder<ParsedTerm> termsBuilder$;
    private ImmutableList<ParsedTerm> terms;
    private ImmutableList.Builder<ImmutableToken> tokensBuilder$;
    private ImmutableList<ImmutableToken> tokens;
    Builder() {
    }
    @Override
    public ParsedQuery.Builder query(@NotNull String query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public ImmutableList.Builder<ParsedTerm> termsBuilder() {
      if (termsBuilder$ == null) {
        termsBuilder$ = ImmutableList.builder();
      }
      return termsBuilder$;
    }
    @Override
    public ImmutableList.Builder<ImmutableToken> tokensBuilder() {
      if (tokensBuilder$ == null) {
        tokensBuilder$ = ImmutableList.builder();
      }
      return tokensBuilder$;
    }
    @Override
    public ParsedQuery build() {
      if (termsBuilder$ != null) {
        this.terms = termsBuilder$.build();
      } else if (this.terms == null) {
        this.terms = ImmutableList.of();
      }
      if (tokensBuilder$ != null) {
        this.tokens = tokensBuilder$.build();
      } else if (this.tokens == null) {
        this.tokens = ImmutableList.of();
      }
      String missing = "";
      if (this.query == null) {
        missing += " query";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ParsedQuery(
          this.query,
          this.terms,
          this.tokens);
    }
  }

}
