package org.graylog.plugins.views.search.validation;

import java.util.Optional;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotNull;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ParsedTerm extends ParsedTerm {

  private final String field;

  private final String value;

  private final Optional<ImmutableToken> keyToken;

  private final Optional<ImmutableToken> valueToken;

  private AutoValue_ParsedTerm(
      String field,
      String value,
      Optional<ImmutableToken> keyToken,
      Optional<ImmutableToken> valueToken) {
    this.field = field;
    this.value = value;
    this.keyToken = keyToken;
    this.valueToken = valueToken;
  }

  @Override
  public String field() {
    return field;
  }

  @Override
  public String value() {
    return value;
  }

  @Override
  public Optional<ImmutableToken> keyToken() {
    return keyToken;
  }

  @Override
  public Optional<ImmutableToken> valueToken() {
    return valueToken;
  }

  @Override
  public String toString() {
    return "ParsedTerm{"
        + "field=" + field + ", "
        + "value=" + value + ", "
        + "keyToken=" + keyToken + ", "
        + "valueToken=" + valueToken
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ParsedTerm) {
      ParsedTerm that = (ParsedTerm) o;
      return this.field.equals(that.field())
          && this.value.equals(that.value())
          && this.keyToken.equals(that.keyToken())
          && this.valueToken.equals(that.valueToken());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= field.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    h$ *= 1000003;
    h$ ^= keyToken.hashCode();
    h$ *= 1000003;
    h$ ^= valueToken.hashCode();
    return h$;
  }

  static final class Builder extends ParsedTerm.Builder {
    private String field;
    private String value;
    private Optional<ImmutableToken> keyToken = Optional.empty();
    private Optional<ImmutableToken> valueToken = Optional.empty();
    Builder() {
    }
    @Override
    public ParsedTerm.Builder field(@NotNull String field) {
      if (field == null) {
        throw new NullPointerException("Null field");
      }
      this.field = field;
      return this;
    }
    @Override
    public ParsedTerm.Builder value(@NotNull String value) {
      if (value == null) {
        throw new NullPointerException("Null value");
      }
      this.value = value;
      return this;
    }
    @Override
    public ParsedTerm.Builder keyToken(@NotNull ImmutableToken keyToken) {
      this.keyToken = Optional.of(keyToken);
      return this;
    }
    @Override
    public ParsedTerm.Builder valueToken(@NotNull ImmutableToken valueToken) {
      this.valueToken = Optional.of(valueToken);
      return this;
    }
    @Override
    public ParsedTerm build() {
      String missing = "";
      if (this.field == null) {
        missing += " field";
      }
      if (this.value == null) {
        missing += " value";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ParsedTerm(
          this.field,
          this.value,
          this.keyToken,
          this.valueToken);
    }
  }

}
