package org.graylog.plugins.views.search.validation;

import java.util.Optional;
import javax.annotation.processing.Generated;
import org.graylog.plugins.views.search.engine.QueryPosition;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ValidationMessage extends ValidationMessage {

  private final Optional<QueryPosition> position;

  private final String errorMessage;

  private final Optional<String> relatedProperty;

  private final ValidationStatus validationStatus;

  private final ValidationType validationType;

  private AutoValue_ValidationMessage(
      Optional<QueryPosition> position,
      String errorMessage,
      Optional<String> relatedProperty,
      ValidationStatus validationStatus,
      ValidationType validationType) {
    this.position = position;
    this.errorMessage = errorMessage;
    this.relatedProperty = relatedProperty;
    this.validationStatus = validationStatus;
    this.validationType = validationType;
  }

  @Override
  public Optional<QueryPosition> position() {
    return position;
  }

  @Override
  public String errorMessage() {
    return errorMessage;
  }

  @Override
  public Optional<String> relatedProperty() {
    return relatedProperty;
  }

  @Override
  public ValidationStatus validationStatus() {
    return validationStatus;
  }

  @Override
  public ValidationType validationType() {
    return validationType;
  }

  @Override
  public String toString() {
    return "ValidationMessage{"
        + "position=" + position + ", "
        + "errorMessage=" + errorMessage + ", "
        + "relatedProperty=" + relatedProperty + ", "
        + "validationStatus=" + validationStatus + ", "
        + "validationType=" + validationType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValidationMessage) {
      ValidationMessage that = (ValidationMessage) o;
      return this.position.equals(that.position())
          && this.errorMessage.equals(that.errorMessage())
          && this.relatedProperty.equals(that.relatedProperty())
          && this.validationStatus.equals(that.validationStatus())
          && this.validationType.equals(that.validationType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= position.hashCode();
    h$ *= 1000003;
    h$ ^= errorMessage.hashCode();
    h$ *= 1000003;
    h$ ^= relatedProperty.hashCode();
    h$ *= 1000003;
    h$ ^= validationStatus.hashCode();
    h$ *= 1000003;
    h$ ^= validationType.hashCode();
    return h$;
  }

  @Override
  public ValidationMessage.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends ValidationMessage.Builder {
    private Optional<QueryPosition> position = Optional.empty();
    private String errorMessage;
    private Optional<String> relatedProperty = Optional.empty();
    private ValidationStatus validationStatus;
    private ValidationType validationType;
    Builder() {
    }
    private Builder(ValidationMessage source) {
      this.position = source.position();
      this.errorMessage = source.errorMessage();
      this.relatedProperty = source.relatedProperty();
      this.validationStatus = source.validationStatus();
      this.validationType = source.validationType();
    }
    @Override
    public ValidationMessage.Builder position(QueryPosition position) {
      this.position = Optional.of(position);
      return this;
    }
    @Override
    public ValidationMessage.Builder errorMessage(String errorMessage) {
      if (errorMessage == null) {
        throw new NullPointerException("Null errorMessage");
      }
      this.errorMessage = errorMessage;
      return this;
    }
    @Override
    public ValidationMessage.Builder relatedProperty(String relatedProperty) {
      this.relatedProperty = Optional.of(relatedProperty);
      return this;
    }
    @Override
    public ValidationMessage.Builder validationStatus(ValidationStatus validationStatus) {
      if (validationStatus == null) {
        throw new NullPointerException("Null validationStatus");
      }
      this.validationStatus = validationStatus;
      return this;
    }
    @Override
    public ValidationMessage.Builder validationType(ValidationType validationType) {
      if (validationType == null) {
        throw new NullPointerException("Null validationType");
      }
      this.validationType = validationType;
      return this;
    }
    @Override
    public ValidationMessage build() {
      String missing = "";
      if (this.errorMessage == null) {
        missing += " errorMessage";
      }
      if (this.validationStatus == null) {
        missing += " validationStatus";
      }
      if (this.validationType == null) {
        missing += " validationType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValidationMessage(
          this.position,
          this.errorMessage,
          this.relatedProperty,
          this.validationStatus,
          this.validationType);
    }
  }

}
