package org.graylog.plugins.views.search.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ValidationRequest extends ValidationRequest {

  private final @NotNull BackendQuery query;

  private final @NotNull Optional<BackendQuery> filter;

  private final @NotNull TimeRange timerange;

  private final @NotNull Set<String> streams;

  private final @NotNull ImmutableSet<Parameter> parameters;

  private final @NotNull ValidationMode validationMode;

  private AutoValue_ValidationRequest(
      @NotNull BackendQuery query,
      @NotNull Optional<BackendQuery> filter,
      @NotNull TimeRange timerange,
      @NotNull Set<String> streams,
      @NotNull ImmutableSet<Parameter> parameters,
      @NotNull ValidationMode validationMode) {
    this.query = query;
    this.filter = filter;
    this.timerange = timerange;
    this.streams = streams;
    this.parameters = parameters;
    this.validationMode = validationMode;
  }

  @Override
  public @NotNull BackendQuery query() {
    return query;
  }

  @Override
  public @NotNull Optional<BackendQuery> filter() {
    return filter;
  }

  @Override
  public @NotNull TimeRange timerange() {
    return timerange;
  }

  @Override
  public @NotNull Set<String> streams() {
    return streams;
  }

  @Override
  public @NotNull ImmutableSet<Parameter> parameters() {
    return parameters;
  }

  @Override
  public @NotNull ValidationMode validationMode() {
    return validationMode;
  }

  @Override
  public String toString() {
    return "ValidationRequest{"
        + "query=" + query + ", "
        + "filter=" + filter + ", "
        + "timerange=" + timerange + ", "
        + "streams=" + streams + ", "
        + "parameters=" + parameters + ", "
        + "validationMode=" + validationMode
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ValidationRequest) {
      ValidationRequest that = (ValidationRequest) o;
      return this.query.equals(that.query())
          && this.filter.equals(that.filter())
          && this.timerange.equals(that.timerange())
          && this.streams.equals(that.streams())
          && this.parameters.equals(that.parameters())
          && this.validationMode.equals(that.validationMode());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= query.hashCode();
    h$ *= 1000003;
    h$ ^= filter.hashCode();
    h$ *= 1000003;
    h$ ^= timerange.hashCode();
    h$ *= 1000003;
    h$ ^= streams.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= validationMode.hashCode();
    return h$;
  }

  static final class Builder extends ValidationRequest.Builder {
    private @NotNull BackendQuery query;
    private @NotNull Optional<BackendQuery> filter = Optional.empty();
    private @NotNull TimeRange timerange;
    private @NotNull Set<String> streams;
    private @NotNull ImmutableSet<Parameter> parameters;
    private @NotNull ValidationMode validationMode;
    Builder() {
    }
    @Override
    public ValidationRequest.Builder query(@NotNull BackendQuery query) {
      if (query == null) {
        throw new NullPointerException("Null query");
      }
      this.query = query;
      return this;
    }
    @Override
    public ValidationRequest.Builder filter(@Nullable BackendQuery filter) {
      this.filter = Optional.ofNullable(filter);
      return this;
    }
    @Override
    public ValidationRequest.Builder timerange(@NotNull TimeRange timerange) {
      if (timerange == null) {
        throw new NullPointerException("Null timerange");
      }
      this.timerange = timerange;
      return this;
    }
    @Override
    public ValidationRequest.Builder streams(@NotNull Set<String> streams) {
      if (streams == null) {
        throw new NullPointerException("Null streams");
      }
      this.streams = streams;
      return this;
    }
    @Override
    public ValidationRequest.Builder parameters(@NotNull ImmutableSet<Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public ValidationRequest.Builder validationMode(ValidationMode validationMode) {
      if (validationMode == null) {
        throw new NullPointerException("Null validationMode");
      }
      this.validationMode = validationMode;
      return this;
    }
    @Override
    public ValidationRequest build() {
      String missing = "";
      if (this.query == null) {
        missing += " query";
      }
      if (this.timerange == null) {
        missing += " timerange";
      }
      if (this.streams == null) {
        missing += " streams";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.validationMode == null) {
        missing += " validationMode";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ValidationRequest(
          this.query,
          this.filter,
          this.timerange,
          this.streams,
          this.parameters,
          this.validationMode);
    }
  }

}
