package org.graylog.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.graylog.grn.GRN;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_GrantDTO extends $AutoValue_GrantDTO {
  AutoValue_GrantDTO(String id, GRN grantee, Capability capability, GRN target, String createdBy,
      ZonedDateTime createdAt, String updatedBy, ZonedDateTime updatedAt,
      Optional<ZonedDateTime> expiresAt) {
    super(id, grantee, capability, target, createdBy, createdAt, updatedBy, updatedAt, expiresAt);
  }

  @JsonIgnore
  @Id
  @ObjectId
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final GRN getGrantee() {
    return grantee();
  }

  @JsonIgnore
  @NotNull
  public final Capability getCapability() {
    return capability();
  }

  @JsonIgnore
  @NotNull
  public final GRN getTarget() {
    return target();
  }

  @JsonIgnore
  public final String getCreatedBy() {
    return createdBy();
  }

  @JsonIgnore
  public final ZonedDateTime getCreatedAt() {
    return createdAt();
  }

  @JsonIgnore
  public final String getUpdatedBy() {
    return updatedBy();
  }

  @JsonIgnore
  public final ZonedDateTime getUpdatedAt() {
    return updatedAt();
  }

  @JsonIgnore
  public final Optional<ZonedDateTime> getExpiresAt() {
    return expiresAt();
  }
}
