/*
 * Copyright (C) 2020 Graylog, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the Server Side Public License, version 1,
 * as published by MongoDB, Inc.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * Server Side Public License for more details.
 *
 * You should have received a copy of the Server Side Public License
 * along with this program. If not, see
 * <http://www.mongodb.com/licensing/server-side-public-license>.
 */
package org.graylog.security.authservice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.graylog2.plugin.rest.ValidationResult;

import java.util.List;
import java.util.Optional;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.EXISTING_PROPERTY,
        property = AuthServiceBackendConfig.TYPE_FIELD,
        visible = true,
        defaultImpl = AuthServiceBackendConfig.FallbackConfig.class)
public interface AuthServiceBackendConfig {
    String TYPE_FIELD = "type";

    @JsonProperty(TYPE_FIELD)
    String type();

    @JsonIgnore
    default void validate(ValidationResult result) {
    }

    @JsonIgnore
    default Optional<List<String>> externalHTTPHosts() {
        return Optional.empty();
    }

    interface Builder<SELF> {
        @JsonProperty(TYPE_FIELD)
        SELF type(String type);
    }

    class FallbackConfig implements AuthServiceBackendConfig {
        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> externalHTTPHosts() {
            throw new UnsupportedOperationException();
        }
    }
}
