package org.graylog2.cluster.lock;

import java.time.ZonedDateTime;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Lock extends Lock {

  private final String resource;

  private final String lockedBy;

  private final ZonedDateTime createdAt;

  private final ZonedDateTime updatedAt;

  private AutoValue_Lock(
      String resource,
      String lockedBy,
      ZonedDateTime createdAt,
      ZonedDateTime updatedAt) {
    this.resource = resource;
    this.lockedBy = lockedBy;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  @Override
  public String resource() {
    return resource;
  }

  @Override
  public String lockedBy() {
    return lockedBy;
  }

  @Override
  public ZonedDateTime createdAt() {
    return createdAt;
  }

  @Override
  public ZonedDateTime updatedAt() {
    return updatedAt;
  }

  @Override
  public String toString() {
    return "Lock{"
        + "resource=" + resource + ", "
        + "lockedBy=" + lockedBy + ", "
        + "createdAt=" + createdAt + ", "
        + "updatedAt=" + updatedAt
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Lock) {
      Lock that = (Lock) o;
      return this.resource.equals(that.resource())
          && this.lockedBy.equals(that.lockedBy())
          && this.createdAt.equals(that.createdAt())
          && this.updatedAt.equals(that.updatedAt());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= resource.hashCode();
    h$ *= 1000003;
    h$ ^= lockedBy.hashCode();
    h$ *= 1000003;
    h$ ^= createdAt.hashCode();
    h$ *= 1000003;
    h$ ^= updatedAt.hashCode();
    return h$;
  }

  static final class Builder extends Lock.Builder {
    private String resource;
    private String lockedBy;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    Builder() {
    }
    @Override
    public Lock.Builder resource(String resource) {
      if (resource == null) {
        throw new NullPointerException("Null resource");
      }
      this.resource = resource;
      return this;
    }
    @Override
    public Lock.Builder lockedBy(String lockedBy) {
      if (lockedBy == null) {
        throw new NullPointerException("Null lockedBy");
      }
      this.lockedBy = lockedBy;
      return this;
    }
    @Override
    public Lock.Builder createdAt(ZonedDateTime createdAt) {
      if (createdAt == null) {
        throw new NullPointerException("Null createdAt");
      }
      this.createdAt = createdAt;
      return this;
    }
    @Override
    public Lock.Builder updatedAt(ZonedDateTime updatedAt) {
      if (updatedAt == null) {
        throw new NullPointerException("Null updatedAt");
      }
      this.updatedAt = updatedAt;
      return this;
    }
    @Override
    public Lock build() {
      String missing = "";
      if (this.resource == null) {
        missing += " resource";
      }
      if (this.lockedBy == null) {
        missing += " lockedBy";
      }
      if (this.createdAt == null) {
        missing += " createdAt";
      }
      if (this.updatedAt == null) {
        missing += " updatedAt";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Lock(
          this.resource,
          this.lockedBy,
          this.createdAt,
          this.updatedAt);
    }
  }

}
