package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_DashboardWidgetEntity extends $AutoValue_DashboardWidgetEntity {
  AutoValue_DashboardWidgetEntity(ValueReference id, ValueReference description,
      ValueReference type, ValueReference cacheTime, TimeRangeEntity timeRange,
      ReferenceMap configuration, Optional<DashboardWidgetEntity.Position> position) {
    super(id, description, type, cacheTime, timeRange, configuration, position);
  }

  @JsonIgnore
  @NotNull
  public final ValueReference getId() {
    return id();
  }

  @JsonIgnore
  @NotNull
  public final ValueReference getDescription() {
    return description();
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getType() {
    return type();
  }

  @JsonIgnore
  @PositiveOrZero
  public final ValueReference getCacheTime() {
    return cacheTime();
  }

  @JsonIgnore
  @NotNull
  public final TimeRangeEntity getTimeRange() {
    return timeRange();
  }

  @JsonIgnore
  @NotNull
  public final ReferenceMap getConfiguration() {
    return configuration();
  }

  @JsonIgnore
  public final Optional<DashboardWidgetEntity.Position> getPosition() {
    return position();
  }
}
