package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

final class AutoValue_OutputEntity extends $AutoValue_OutputEntity {
  AutoValue_OutputEntity(ValueReference title, ValueReference type, ReferenceMap configuration) {
    super(title, type, configuration);
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getTitle() {
    return title();
  }

  @JsonIgnore
  @NotBlank
  public final ValueReference getType() {
    return type();
  }

  @JsonIgnore
  @NotNull
  public final ReferenceMap getConfiguration() {
    return configuration();
  }
}
