package org.graylog2.indexer.rotation.strategies;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_TimeBasedRotationStrategyConfig extends TimeBasedRotationStrategyConfig {

  private final String type;

  private final Period rotationPeriod;

  private final Period maxRotationPeriod;

  private final boolean rotateEmptyIndexSet;

  $AutoValue_TimeBasedRotationStrategyConfig(
      String type,
      Period rotationPeriod,
      @Nullable Period maxRotationPeriod,
      boolean rotateEmptyIndexSet) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (rotationPeriod == null) {
      throw new NullPointerException("Null rotationPeriod");
    }
    this.rotationPeriod = rotationPeriod;
    this.maxRotationPeriod = maxRotationPeriod;
    this.rotateEmptyIndexSet = rotateEmptyIndexSet;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("rotation_period")
  @Override
  public Period rotationPeriod() {
    return rotationPeriod;
  }

  @JsonProperty("max_rotation_period")
  @Nullable
  @Override
  public Period maxRotationPeriod() {
    return maxRotationPeriod;
  }

  @JsonProperty("rotate_empty_index_set")
  @Override
  public boolean rotateEmptyIndexSet() {
    return rotateEmptyIndexSet;
  }

  @Override
  public String toString() {
    return "TimeBasedRotationStrategyConfig{"
        + "type=" + type + ", "
        + "rotationPeriod=" + rotationPeriod + ", "
        + "maxRotationPeriod=" + maxRotationPeriod + ", "
        + "rotateEmptyIndexSet=" + rotateEmptyIndexSet
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TimeBasedRotationStrategyConfig) {
      TimeBasedRotationStrategyConfig that = (TimeBasedRotationStrategyConfig) o;
      return this.type.equals(that.type())
          && this.rotationPeriod.equals(that.rotationPeriod())
          && (this.maxRotationPeriod == null ? that.maxRotationPeriod() == null : this.maxRotationPeriod.equals(that.maxRotationPeriod()))
          && this.rotateEmptyIndexSet == that.rotateEmptyIndexSet();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= rotationPeriod.hashCode();
    h$ *= 1000003;
    h$ ^= (maxRotationPeriod == null) ? 0 : maxRotationPeriod.hashCode();
    h$ *= 1000003;
    h$ ^= rotateEmptyIndexSet ? 1231 : 1237;
    return h$;
  }

  static class Builder extends TimeBasedRotationStrategyConfig.Builder {
    private String type;
    private Period rotationPeriod;
    private Period maxRotationPeriod;
    private Boolean rotateEmptyIndexSet;
    Builder() {
    }
    @Override
    public TimeBasedRotationStrategyConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public TimeBasedRotationStrategyConfig.Builder rotationPeriod(@NotNull Period rotationPeriod) {
      if (rotationPeriod == null) {
        throw new NullPointerException("Null rotationPeriod");
      }
      this.rotationPeriod = rotationPeriod;
      return this;
    }
    @Override
    public TimeBasedRotationStrategyConfig.Builder maxRotationPeriod(@Nullable Period maxRotationPeriod) {
      this.maxRotationPeriod = maxRotationPeriod;
      return this;
    }
    @Override
    public TimeBasedRotationStrategyConfig.Builder rotateEmptyIndexSet(boolean rotateEmptyIndexSet) {
      this.rotateEmptyIndexSet = rotateEmptyIndexSet;
      return this;
    }
    @Override
    public TimeBasedRotationStrategyConfig build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.rotationPeriod == null) {
        missing += " rotationPeriod";
      }
      if (this.rotateEmptyIndexSet == null) {
        missing += " rotateEmptyIndexSet";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TimeBasedRotationStrategyConfig(
          this.type,
          this.rotationPeriod,
          this.maxRotationPeriod,
          this.rotateEmptyIndexSet);
    }
  }

}
