package org.graylog2.indexer.rotation.strategies;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import javax.annotation.Nullable;
import org.joda.time.Period;

final class AutoValue_TimeBasedRotationStrategyConfig extends $AutoValue_TimeBasedRotationStrategyConfig {
  AutoValue_TimeBasedRotationStrategyConfig(String type, Period rotationPeriod,
      Period maxRotationPeriod, boolean rotateEmptyIndexSet) {
    super(type, rotationPeriod, maxRotationPeriod, rotateEmptyIndexSet);
  }

  @JsonIgnore
  public final String getType() {
    return type();
  }

  @JsonIgnore
  public final Period getRotationPeriod() {
    return rotationPeriod();
  }

  @JsonIgnore
  @Nullable
  public final Period getMaxRotationPeriod() {
    return maxRotationPeriod();
  }

  @JsonIgnore
  public final boolean isRotateEmptyIndexSet() {
    return rotateEmptyIndexSet();
  }
}
