package org.graylog2.lookup.adapters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.Optional;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

final class AutoValue_DSVHTTPDataAdapter_Config extends $AutoValue_DSVHTTPDataAdapter_Config {
  AutoValue_DSVHTTPDataAdapter_Config(String type, String url, String separator,
      String lineSeparator, String quotechar, String ignorechar, Integer keyColumn,
      Optional<Boolean> checkPresenceOnly, Optional<Integer> valueColumn, long refreshInterval,
      Optional<Boolean> caseInsensitiveLookup) {
    super(type, url, separator, lineSeparator, quotechar, ignorechar, keyColumn, checkPresenceOnly, valueColumn, refreshInterval, caseInsensitiveLookup);
  }

  @JsonIgnore
  public final String getType() {
    return type();
  }

  @JsonIgnore
  @NotEmpty
  public final String getUrl() {
    return url();
  }

  @JsonIgnore
  @Size(
      min = 1,
      max = 1
  )
  @NotEmpty
  public final String getSeparator() {
    return separator();
  }

  @JsonIgnore
  @Size(
      min = 1,
      max = 1
  )
  @NotEmpty
  public final String getLineSeparator() {
    return lineSeparator();
  }

  @JsonIgnore
  @Size(
      min = 1,
      max = 1
  )
  @NotEmpty
  public final String getQuotechar() {
    return quotechar();
  }

  @JsonIgnore
  @Size(
      min = 1
  )
  @NotEmpty
  public final String getIgnorechar() {
    return ignorechar();
  }

  @JsonIgnore
  @NotEmpty
  public final Integer getKeyColumn() {
    return keyColumn();
  }

  @JsonIgnore
  public final Optional<Boolean> getCheckPresenceOnly() {
    return checkPresenceOnly();
  }

  @JsonIgnore
  @NotEmpty
  public final Optional<Integer> getValueColumn() {
    return valueColumn();
  }

  @JsonIgnore
  @Min(1)
  public final long getRefreshInterval() {
    return refreshInterval();
  }

  @JsonIgnore
  public final Optional<Boolean> getCaseInsensitiveLookup() {
    return caseInsensitiveLookup();
  }
}
