package org.graylog2.lookup.caches;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import javax.validation.constraints.Min;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_CaffeineLookupCache_Config extends CaffeineLookupCache.Config {

  private final String type;

  private final @Min(0L) int maxSize;

  private final @Min(0L) long expireAfterAccess;

  private final TimeUnit expireAfterAccessUnit;

  private final @Min(0L) long expireAfterWrite;

  private final TimeUnit expireAfterWriteUnit;

  $AutoValue_CaffeineLookupCache_Config(
      String type,
      @Min(0L) int maxSize,
      @Min(0L) long expireAfterAccess,
      @Nullable TimeUnit expireAfterAccessUnit,
      @Min(0L) long expireAfterWrite,
      @Nullable TimeUnit expireAfterWriteUnit) {
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    this.maxSize = maxSize;
    this.expireAfterAccess = expireAfterAccess;
    this.expireAfterAccessUnit = expireAfterAccessUnit;
    this.expireAfterWrite = expireAfterWrite;
    this.expireAfterWriteUnit = expireAfterWriteUnit;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("max_size")
  @Override
  public @Min(0L) int maxSize() {
    return maxSize;
  }

  @JsonProperty("expire_after_access")
  @Override
  public @Min(0L) long expireAfterAccess() {
    return expireAfterAccess;
  }

  @Nullable
  @JsonProperty("expire_after_access_unit")
  @Override
  public TimeUnit expireAfterAccessUnit() {
    return expireAfterAccessUnit;
  }

  @JsonProperty("expire_after_write")
  @Override
  public @Min(0L) long expireAfterWrite() {
    return expireAfterWrite;
  }

  @Nullable
  @JsonProperty("expire_after_write_unit")
  @Override
  public TimeUnit expireAfterWriteUnit() {
    return expireAfterWriteUnit;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "maxSize=" + maxSize + ", "
        + "expireAfterAccess=" + expireAfterAccess + ", "
        + "expireAfterAccessUnit=" + expireAfterAccessUnit + ", "
        + "expireAfterWrite=" + expireAfterWrite + ", "
        + "expireAfterWriteUnit=" + expireAfterWriteUnit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CaffeineLookupCache.Config) {
      CaffeineLookupCache.Config that = (CaffeineLookupCache.Config) o;
      return this.type.equals(that.type())
          && this.maxSize == that.maxSize()
          && this.expireAfterAccess == that.expireAfterAccess()
          && (this.expireAfterAccessUnit == null ? that.expireAfterAccessUnit() == null : this.expireAfterAccessUnit.equals(that.expireAfterAccessUnit()))
          && this.expireAfterWrite == that.expireAfterWrite()
          && (this.expireAfterWriteUnit == null ? that.expireAfterWriteUnit() == null : this.expireAfterWriteUnit.equals(that.expireAfterWriteUnit()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= maxSize;
    h$ *= 1000003;
    h$ ^= (int) ((expireAfterAccess >>> 32) ^ expireAfterAccess);
    h$ *= 1000003;
    h$ ^= (expireAfterAccessUnit == null) ? 0 : expireAfterAccessUnit.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((expireAfterWrite >>> 32) ^ expireAfterWrite);
    h$ *= 1000003;
    h$ ^= (expireAfterWriteUnit == null) ? 0 : expireAfterWriteUnit.hashCode();
    return h$;
  }

  static class Builder extends CaffeineLookupCache.Config.Builder {
    private String type;
    private Integer maxSize;
    private Long expireAfterAccess;
    private TimeUnit expireAfterAccessUnit;
    private Long expireAfterWrite;
    private TimeUnit expireAfterWriteUnit;
    Builder() {
    }
    @Override
    public CaffeineLookupCache.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public CaffeineLookupCache.Config.Builder maxSize(int maxSize) {
      this.maxSize = maxSize;
      return this;
    }
    @Override
    public CaffeineLookupCache.Config.Builder expireAfterAccess(long expireAfterAccess) {
      this.expireAfterAccess = expireAfterAccess;
      return this;
    }
    @Override
    public CaffeineLookupCache.Config.Builder expireAfterAccessUnit(@Nullable TimeUnit expireAfterAccessUnit) {
      this.expireAfterAccessUnit = expireAfterAccessUnit;
      return this;
    }
    @Override
    public CaffeineLookupCache.Config.Builder expireAfterWrite(long expireAfterWrite) {
      this.expireAfterWrite = expireAfterWrite;
      return this;
    }
    @Override
    public CaffeineLookupCache.Config.Builder expireAfterWriteUnit(@Nullable TimeUnit expireAfterWriteUnit) {
      this.expireAfterWriteUnit = expireAfterWriteUnit;
      return this;
    }
    @Override
    public CaffeineLookupCache.Config build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.maxSize == null) {
        missing += " maxSize";
      }
      if (this.expireAfterAccess == null) {
        missing += " expireAfterAccess";
      }
      if (this.expireAfterWrite == null) {
        missing += " expireAfterWrite";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_CaffeineLookupCache_Config(
          this.type,
          this.maxSize,
          this.expireAfterAccess,
          this.expireAfterAccessUnit,
          this.expireAfterWrite,
          this.expireAfterWriteUnit);
    }
  }

}
