package org.graylog2.plugin.indexer.searches.timeranges;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AbsoluteRange extends AbsoluteRange {

  private final DateTime from;

  private final DateTime to;

  private AutoValue_AbsoluteRange(
      DateTime from,
      DateTime to) {
    this.from = from;
    this.to = to;
  }

  @JsonProperty
  @Override
  public DateTime from() {
    return from;
  }

  @JsonProperty
  @Override
  public DateTime to() {
    return to;
  }

  @Override
  public String toString() {
    return "AbsoluteRange{"
        + "from=" + from + ", "
        + "to=" + to
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AbsoluteRange) {
      AbsoluteRange that = (AbsoluteRange) o;
      return this.from.equals(that.from())
          && this.to.equals(that.to());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= from.hashCode();
    h$ *= 1000003;
    h$ ^= to.hashCode();
    return h$;
  }

  static final class Builder extends AbsoluteRange.Builder {
    private DateTime from;
    private DateTime to;
    Builder() {
    }
    @Override
    public AbsoluteRange.Builder from(DateTime from) {
      if (from == null) {
        throw new NullPointerException("Null from");
      }
      this.from = from;
      return this;
    }
    @Override
    public AbsoluteRange.Builder to(DateTime to) {
      if (to == null) {
        throw new NullPointerException("Null to");
      }
      this.to = to;
      return this;
    }
    @Override
    public AbsoluteRange build() {
      String missing = "";
      if (this.from == null) {
        missing += " from";
      }
      if (this.to == null) {
        missing += " to";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AbsoluteRange(
          this.from,
          this.to);
    }
  }

}
