package org.graylog2.rest.models.search.responses;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import java.lang.String;
import java.util.Map;
import java.util.Set;

final class AutoValue_TermsHistogramResult extends $AutoValue_TermsHistogramResult {
  AutoValue_TermsHistogramResult(long time, String interval, long size,
      Map<Long, TermsResult> buckets, Set<String> terms, String builtQuery,
      TimeRange queriedTimerange) {
    super(time, interval, size, buckets, terms, builtQuery, queriedTimerange);
  }

  @JsonIgnore
  public final long getTime() {
    return time();
  }

  @JsonIgnore
  public final String getInterval() {
    return interval();
  }

  @JsonIgnore
  public final long getSize() {
    return size();
  }

  @JsonIgnore
  public final Map<Long, TermsResult> getBuckets() {
    return buckets();
  }

  @JsonIgnore
  public final Set<String> getTerms() {
    return terms();
  }

  @JsonIgnore
  public final String getBuiltQuery() {
    return builtQuery();
  }

  @JsonIgnore
  public final TimeRange getQueriedTimerange() {
    return queriedTimerange();
  }
}
