package org.graylog2.rest.models.system.lookup;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.String;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.graylog2.plugin.lookup.LookupCacheConfiguration;

final class AutoValue_CacheApi extends $AutoValue_CacheApi {
  AutoValue_CacheApi(String id, String scope, String title, String description, String name,
      String contentPack, LookupCacheConfiguration config) {
    super(id, scope, title, description, name, contentPack, config);
  }

  @JsonIgnore
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  @Nullable
  public final String getScope() {
    return scope();
  }

  @JsonIgnore
  @NotEmpty
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  @NotEmpty
  public final String getName() {
    return name();
  }

  @JsonIgnore
  @Nullable
  public final String getContentPack() {
    return contentPack();
  }

  @JsonIgnore
  @NotNull
  public final LookupCacheConfiguration getConfig() {
    return config();
  }
}
