package org.graylog2.rest.models.users.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.graylog.security.permissions.GRNPermission;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.users.requests.Startpage;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
abstract class $AutoValue_UserSummary extends UserSummary {

  private final String id;

  private final String username;

  private final String email;

  private final String firstName;

  private final String lastName;

  private final String fullName;

  private final List<WildcardPermission> permissions;

  private final List<GRNPermission> grnPermissions;

  private final Map<String, Object> preferences;

  private final String timezone;

  private final Long sessionTimeoutMs;

  private final boolean readOnly;

  private final boolean external;

  private final Startpage startpage;

  private final Set<String> roles;

  private final boolean sessionActive;

  private final Date lastActivity;

  private final String clientAddress;

  private final User.AccountStatus accountStatus;

  private final boolean isServiceAccount;

  $AutoValue_UserSummary(
      @Nullable String id,
      String username,
      String email,
      @Nullable String firstName,
      @Nullable String lastName,
      @Nullable String fullName,
      List<WildcardPermission> permissions,
      List<GRNPermission> grnPermissions,
      @Nullable Map<String, Object> preferences,
      @Nullable String timezone,
      @Nullable Long sessionTimeoutMs,
      boolean readOnly,
      boolean external,
      @Nullable Startpage startpage,
      @Nullable Set<String> roles,
      boolean sessionActive,
      @Nullable Date lastActivity,
      @Nullable String clientAddress,
      User.AccountStatus accountStatus,
      boolean isServiceAccount) {
    this.id = id;
    if (username == null) {
      throw new NullPointerException("Null username");
    }
    this.username = username;
    if (email == null) {
      throw new NullPointerException("Null email");
    }
    this.email = email;
    this.firstName = firstName;
    this.lastName = lastName;
    this.fullName = fullName;
    if (permissions == null) {
      throw new NullPointerException("Null permissions");
    }
    this.permissions = permissions;
    if (grnPermissions == null) {
      throw new NullPointerException("Null grnPermissions");
    }
    this.grnPermissions = grnPermissions;
    this.preferences = preferences;
    this.timezone = timezone;
    this.sessionTimeoutMs = sessionTimeoutMs;
    this.readOnly = readOnly;
    this.external = external;
    this.startpage = startpage;
    this.roles = roles;
    this.sessionActive = sessionActive;
    this.lastActivity = lastActivity;
    this.clientAddress = clientAddress;
    if (accountStatus == null) {
      throw new NullPointerException("Null accountStatus");
    }
    this.accountStatus = accountStatus;
    this.isServiceAccount = isServiceAccount;
  }

  @JsonProperty
  @Nullable
  @Override
  public String id() {
    return id;
  }

  @JsonProperty
  @Override
  public String username() {
    return username;
  }

  @JsonProperty
  @Override
  public String email() {
    return email;
  }

  @JsonProperty
  @Nullable
  @Override
  public String firstName() {
    return firstName;
  }

  @JsonProperty
  @Nullable
  @Override
  public String lastName() {
    return lastName;
  }

  @JsonProperty
  @Nullable
  @Override
  public String fullName() {
    return fullName;
  }

  @JsonProperty
  @JsonSerialize(contentUsing = ToStringSerializer.class)
  @Override
  public List<WildcardPermission> permissions() {
    return permissions;
  }

  @JsonProperty
  @Override
  public List<GRNPermission> grnPermissions() {
    return grnPermissions;
  }

  @JsonProperty
  @Nullable
  @Override
  public Map<String, Object> preferences() {
    return preferences;
  }

  @JsonProperty
  @Nullable
  @Override
  public String timezone() {
    return timezone;
  }

  @JsonProperty
  @Nullable
  @Override
  public Long sessionTimeoutMs() {
    return sessionTimeoutMs;
  }

  @JsonProperty("read_only")
  @Override
  public boolean readOnly() {
    return readOnly;
  }

  @JsonProperty
  @Override
  public boolean external() {
    return external;
  }

  @JsonProperty
  @Nullable
  @Override
  public Startpage startpage() {
    return startpage;
  }

  @JsonProperty
  @Nullable
  @Override
  public Set<String> roles() {
    return roles;
  }

  @JsonProperty("session_active")
  @Override
  public boolean sessionActive() {
    return sessionActive;
  }

  @JsonProperty("last_activity")
  @Nullable
  @Override
  public Date lastActivity() {
    return lastActivity;
  }

  @JsonProperty("client_address")
  @Nullable
  @Override
  public String clientAddress() {
    return clientAddress;
  }

  @JsonProperty("account_status")
  @Override
  public User.AccountStatus accountStatus() {
    return accountStatus;
  }

  @JsonProperty("service_account")
  @Override
  public boolean isServiceAccount() {
    return isServiceAccount;
  }

  @Override
  public String toString() {
    return "UserSummary{"
        + "id=" + id + ", "
        + "username=" + username + ", "
        + "email=" + email + ", "
        + "firstName=" + firstName + ", "
        + "lastName=" + lastName + ", "
        + "fullName=" + fullName + ", "
        + "permissions=" + permissions + ", "
        + "grnPermissions=" + grnPermissions + ", "
        + "preferences=" + preferences + ", "
        + "timezone=" + timezone + ", "
        + "sessionTimeoutMs=" + sessionTimeoutMs + ", "
        + "readOnly=" + readOnly + ", "
        + "external=" + external + ", "
        + "startpage=" + startpage + ", "
        + "roles=" + roles + ", "
        + "sessionActive=" + sessionActive + ", "
        + "lastActivity=" + lastActivity + ", "
        + "clientAddress=" + clientAddress + ", "
        + "accountStatus=" + accountStatus + ", "
        + "isServiceAccount=" + isServiceAccount
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof UserSummary) {
      UserSummary that = (UserSummary) o;
      return (this.id == null ? that.id() == null : this.id.equals(that.id()))
          && this.username.equals(that.username())
          && this.email.equals(that.email())
          && (this.firstName == null ? that.firstName() == null : this.firstName.equals(that.firstName()))
          && (this.lastName == null ? that.lastName() == null : this.lastName.equals(that.lastName()))
          && (this.fullName == null ? that.fullName() == null : this.fullName.equals(that.fullName()))
          && this.permissions.equals(that.permissions())
          && this.grnPermissions.equals(that.grnPermissions())
          && (this.preferences == null ? that.preferences() == null : this.preferences.equals(that.preferences()))
          && (this.timezone == null ? that.timezone() == null : this.timezone.equals(that.timezone()))
          && (this.sessionTimeoutMs == null ? that.sessionTimeoutMs() == null : this.sessionTimeoutMs.equals(that.sessionTimeoutMs()))
          && this.readOnly == that.readOnly()
          && this.external == that.external()
          && (this.startpage == null ? that.startpage() == null : this.startpage.equals(that.startpage()))
          && (this.roles == null ? that.roles() == null : this.roles.equals(that.roles()))
          && this.sessionActive == that.sessionActive()
          && (this.lastActivity == null ? that.lastActivity() == null : this.lastActivity.equals(that.lastActivity()))
          && (this.clientAddress == null ? that.clientAddress() == null : this.clientAddress.equals(that.clientAddress()))
          && this.accountStatus.equals(that.accountStatus())
          && this.isServiceAccount == that.isServiceAccount();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (id == null) ? 0 : id.hashCode();
    h$ *= 1000003;
    h$ ^= username.hashCode();
    h$ *= 1000003;
    h$ ^= email.hashCode();
    h$ *= 1000003;
    h$ ^= (firstName == null) ? 0 : firstName.hashCode();
    h$ *= 1000003;
    h$ ^= (lastName == null) ? 0 : lastName.hashCode();
    h$ *= 1000003;
    h$ ^= (fullName == null) ? 0 : fullName.hashCode();
    h$ *= 1000003;
    h$ ^= permissions.hashCode();
    h$ *= 1000003;
    h$ ^= grnPermissions.hashCode();
    h$ *= 1000003;
    h$ ^= (preferences == null) ? 0 : preferences.hashCode();
    h$ *= 1000003;
    h$ ^= (timezone == null) ? 0 : timezone.hashCode();
    h$ *= 1000003;
    h$ ^= (sessionTimeoutMs == null) ? 0 : sessionTimeoutMs.hashCode();
    h$ *= 1000003;
    h$ ^= readOnly ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= external ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (startpage == null) ? 0 : startpage.hashCode();
    h$ *= 1000003;
    h$ ^= (roles == null) ? 0 : roles.hashCode();
    h$ *= 1000003;
    h$ ^= sessionActive ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (lastActivity == null) ? 0 : lastActivity.hashCode();
    h$ *= 1000003;
    h$ ^= (clientAddress == null) ? 0 : clientAddress.hashCode();
    h$ *= 1000003;
    h$ ^= accountStatus.hashCode();
    h$ *= 1000003;
    h$ ^= isServiceAccount ? 1231 : 1237;
    return h$;
  }

}
