/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.types.EmailEventNotificationConfig;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.email.EmailFactory;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSender.class);
    private final EmailRecipients.Factory emailRecipientsFactory;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final ObjectMapperProvider objectMapperProvider;
    private final Engine templateEngine;
    private final Engine htmlTemplateEngine;
    private final EmailFactory emailFactory;

    @Inject
    public EmailSender(EmailRecipients.Factory emailRecipientsFactory, NotificationService notificationService, NodeId nodeId, ObjectMapperProvider objectMapperProvider, Engine templateEngine, @Named(value="HtmlSafe") Engine htmlTemplateEngine, EmailFactory emailFactory) {
        this.emailRecipientsFactory = Objects.requireNonNull(emailRecipientsFactory, "emailRecipientsFactory");
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
        this.objectMapperProvider = Objects.requireNonNull(objectMapperProvider, "objectMapperProvider)");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
        this.htmlTemplateEngine = Objects.requireNonNull(htmlTemplateEngine, "htmlTemplateEngine");
        this.emailFactory = Objects.requireNonNull(emailFactory, "emailFactory");
    }

    @VisibleForTesting
    private String buildSubject(EmailEventNotificationConfig config, Map<String, Object> model) {
        String template = Strings.isNullOrEmpty((String)config.subject()) ? "Graylog event notification: ${event_definition_title}" : config.subject();
        return this.templateEngine.transform(template, model);
    }

    @VisibleForTesting
    private String buildBody(EmailEventNotificationConfig config, Map<String, Object> model) {
        String template = Strings.isNullOrEmpty((String)config.bodyTemplate()) ? "--- [Event Definition] ---------------------------\nTitle:       ${event_definition_title}\nDescription: ${event_definition_description}\nType:        ${event_definition_type}\n--- [Event] --------------------------------------\nTimestamp:            ${event.timestamp}\nMessage:              ${event.message}\nSource:               ${event.source}\nKey:                  ${event.key}\nPriority:             ${event.priority}\nAlert:                ${event.alert}\nTimestamp Processing: ${event.timestamp}\nTimerange Start:      ${event.timerange_start}\nTimerange End:        ${event.timerange_end}\nSource Streams:       ${event.source_streams}\nFields:\n${foreach event.fields field}  ${field.key}: ${field.value}\n${end}\n${if backlog}\n--- [Backlog] ------------------------------------\nLast messages accounting for this alert:\n${foreach backlog message}\n${message}\n\n${end}\n${end}\n\n" : config.bodyTemplate();
        return this.templateEngine.transform(template, model);
    }

    @VisibleForTesting
    private String buildHtmlBody(EmailEventNotificationConfig config, Map<String, Object> model) {
        return this.htmlTemplateEngine.transform(config.htmlBodyTemplate(), model);
    }

    private Map<String, Object> getModel(EventNotificationContext ctx, ImmutableList<MessageSummary> backlog, DateTimeZone timeZone) {
        EventNotificationModelData modelData = EventNotificationModelData.of(ctx, backlog);
        return (Map)this.objectMapperProvider.getForTimeZone(timeZone).convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
    }

    private void sendEmail(EmailEventNotificationConfig config, String emailAddress, Map<String, Object> model) throws TransportConfigurationException, EmailException {
        LOG.debug("Sending mail to " + emailAddress);
        if (!this.emailFactory.isEmailTransportEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        Email email = this.createEmailWithBody(config, model);
        if (!Strings.isNullOrEmpty((String)config.sender())) {
            email.setFrom(config.sender());
        }
        if (!Strings.isNullOrEmpty((String)config.replyTo())) {
            email.addReplyTo(config.replyTo());
        }
        if (email.getFromAddress() == null) {
            throw new TransportConfigurationException("No from address specified for email transport.");
        }
        email.setSubject(this.buildSubject(config, model));
        email.addTo(emailAddress);
        email.send();
    }

    Email createEmailWithBody(EmailEventNotificationConfig config, Map<String, Object> model) throws EmailException {
        if (!Strings.isNullOrEmpty((String)config.htmlBodyTemplate())) {
            HtmlEmail email = this.emailFactory.htmlEmail();
            email.setTextMsg(this.buildBody(config, model));
            email.setHtmlMsg(this.buildHtmlBody(config, model));
            return email;
        }
        SimpleEmail email = this.emailFactory.simpleEmail();
        email.setMsg(this.buildBody(config, model));
        return email;
    }

    void sendEmails(EmailEventNotificationConfig notificationConfig, EventNotificationContext ctx, ImmutableList<MessageSummary> backlog) throws TransportConfigurationException, EmailException, ConfigurationError {
        if (!this.emailFactory.isEmailTransportEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        EmailRecipients emailRecipients = this.emailRecipientsFactory.create(new ArrayList<String>(notificationConfig.userRecipients()), new ArrayList<String>(notificationConfig.emailRecipients()));
        if (emailRecipients.isEmpty()) {
            LOG.debug("Cannot send emails: empty recipient list.");
            return;
        }
        Set<String> recipientsSet = emailRecipients.getEmailRecipients();
        if (recipientsSet.size() == 0) {
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.NORMAL).addDetail("title", StringUtils.f("No recipients have been defined for notification with ID [%s]!", ctx.notificationId())).addDetail("description", "To fix this, go to the notification configuration and add at least one alert recipient.");
            this.notificationService.publishIfFirst(notification);
        }
        Map<String, Object> model = this.getModel(ctx, backlog, notificationConfig.timeZone());
        for (String email : recipientsSet) {
            this.sendEmail(notificationConfig, email, model);
        }
    }

    static class ConfigurationError
    extends Exception {
        ConfigurationError(String message) {
            super(message);
        }
    }
}

