/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManager;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import org.graylog2.bindings.providers.MongoConnectionProvider;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.bootstrap.preflight.PreflightJerseyService;
import org.graylog2.bootstrap.preflight.PreflightRestResourcesBinding;
import org.graylog2.bootstrap.preflight.web.resources.PreflightAssetsResource;
import org.graylog2.bootstrap.preflight.web.resources.PreflightResource;
import org.graylog2.bootstrap.preflight.web.resources.PreflightStatusResource;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.NodeServiceImpl;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.bindings.providers.ServiceManagerProvider;

public class PreflightWebModule
extends Graylog2Module {
    public static final String FEATURE_FLAG_PREFLIGHT_WEB_ENABLED = "preflight_web";

    protected void configure() {
        this.bind(ServiceManager.class).toProvider(ServiceManagerProvider.class).asEagerSingleton();
        this.bind(MongoConnection.class).toProvider(MongoConnectionProvider.class);
        this.bind(NodeService.class).to(NodeServiceImpl.class);
        this.bind(PreflightConfigService.class);
        this.addPreflightRestResource(PreflightResource.class);
        this.addPreflightRestResource(PreflightStatusResource.class);
        this.addPreflightRestResource(PreflightAssetsResource.class);
        Multibinder serviceBinder = Multibinder.newSetBinder((Binder)this.binder(), Service.class);
        serviceBinder.addBinding().to(PreflightJerseyService.class);
        MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<MessageInput.Factory<? extends MessageInput>>(){});
    }

    protected void addPreflightRestResource(Class<?> restResourceClass) {
        this.preflightRestResourceBinder().addBinding().toInstance(restResourceClass);
    }

    private Multibinder<Class<?>> preflightRestResourceBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<Class<?>>(){}, PreflightRestResourcesBinding.class);
    }
}

