/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.ParameterException;
import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.ValidatorMethod;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import com.github.joschi.jadconfig.validators.URIAbsoluteValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import org.graylog2.plugin.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConfiguration.class);
    private static final int GRAYLOG_DEFAULT_PORT = 9000;
    public static final String OVERRIDE_HEADER = "X-Graylog-Server-URL";
    public static final String PATH_WEB = "";
    public static final String PATH_API = "api/";
    @Parameter(value="http_bind_address", required=true)
    private HostAndPort httpBindAddress = HostAndPort.fromParts((String)"127.0.0.1", (int)9000);
    @Parameter(value="http_publish_uri", validator=URIAbsoluteValidator.class)
    private URI httpPublishUri;
    @Parameter(value="http_enable_cors")
    private boolean httpEnableCors = false;
    @Parameter(value="http_enable_gzip")
    private boolean httpEnableGzip = true;
    @Parameter(value="http_max_header_size", required=true, validator=PositiveIntegerValidator.class)
    private int httpMaxHeaderSize = 8192;
    @Parameter(value="http_thread_pool_size", required=true, validator=PositiveIntegerValidator.class)
    private int httpThreadPoolSize = 64;
    @Parameter(value="http_selector_runners_count", required=true, validator=PositiveIntegerValidator.class)
    private int httpSelectorRunnersCount = 1;
    @Parameter(value="http_enable_tls")
    private boolean httpEnableTls = false;
    @Parameter(value="http_tls_cert_file")
    private Path httpTlsCertFile;
    @Parameter(value="http_tls_key_file")
    private Path httpTlsKeyFile;
    @Parameter(value="http_tls_key_password")
    private String httpTlsKeyPassword;
    @Parameter(value="http_external_uri")
    private URI httpExternalUri;
    @Parameter(value="http_allow_embedding")
    private boolean httpAllowEmbedding = false;

    public HostAndPort getHttpBindAddress() {
        return this.httpBindAddress.requireBracketsForIPv6().withDefaultPort(9000);
    }

    public String getUriScheme() {
        return this.isHttpEnableTls() ? "https" : "http";
    }

    @Nullable
    private InetAddress toInetAddress(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            LOG.debug("Couldn't resolve \"{}\"", (Object)host, (Object)e);
            return null;
        }
    }

    public URI getHttpPublishUri() {
        if (this.httpPublishUri == null) {
            URI defaultHttpUri = this.getDefaultHttpUri();
            LOG.debug("No \"http_publish_uri\" set. Using default <{}>.", (Object)defaultHttpUri);
            return defaultHttpUri;
        }
        InetAddress inetAddress = this.toInetAddress(this.httpPublishUri.getHost());
        if (Tools.isWildcardInetAddress(inetAddress)) {
            URI defaultHttpUri = this.getDefaultHttpUri(this.httpPublishUri.getPath());
            LOG.warn("\"{}\" is not a valid setting for \"http_publish_uri\". Using default <{}>.", (Object)this.httpPublishUri, (Object)defaultHttpUri);
            return defaultHttpUri;
        }
        return Tools.normalizeURI(this.httpPublishUri, this.httpPublishUri.getScheme(), 9000, this.httpPublishUri.getPath());
    }

    @VisibleForTesting
    URI getDefaultHttpUri() {
        return this.getDefaultHttpUri("/");
    }

    private URI getDefaultHttpUri(String path) {
        URI publishUri;
        HostAndPort bindAddress = this.getHttpBindAddress();
        InetAddress inetAddress = this.toInetAddress(bindAddress.getHost());
        if (inetAddress != null && Tools.isWildcardInetAddress(inetAddress)) {
            InetAddress guessedAddress;
            try {
                guessedAddress = Tools.guessPrimaryNetworkAddress(inetAddress instanceof Inet4Address);
                if (guessedAddress.isLoopbackAddress()) {
                    LOG.debug("Using loopback address {}", (Object)guessedAddress);
                }
            }
            catch (Exception e) {
                LOG.error("Could not guess primary network address for \"http_publish_uri\". Please configure it in your Graylog configuration.", (Throwable)e);
                throw new ParameterException("No http_publish_uri.", (Throwable)e);
            }
            try {
                publishUri = new URI(this.getUriScheme(), null, guessedAddress.getHostAddress(), bindAddress.getPort(), path, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid http_publish_uri.", e);
            }
        }
        try {
            publishUri = new URI(this.getUriScheme(), null, this.getHttpBindAddress().getHost(), this.getHttpBindAddress().getPort(), path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid http_publish_uri.", e);
        }
        return publishUri;
    }

    public boolean isHttpEnableCors() {
        return this.httpEnableCors;
    }

    public boolean isHttpEnableGzip() {
        return this.httpEnableGzip;
    }

    public int getHttpMaxHeaderSize() {
        return this.httpMaxHeaderSize;
    }

    public int getHttpThreadPoolSize() {
        return this.httpThreadPoolSize;
    }

    public int getHttpSelectorRunnersCount() {
        return this.httpSelectorRunnersCount;
    }

    public boolean isHttpEnableTls() {
        return this.httpEnableTls;
    }

    public Path getHttpTlsCertFile() {
        return this.httpTlsCertFile;
    }

    public Path getHttpTlsKeyFile() {
        return this.httpTlsKeyFile;
    }

    public String getHttpTlsKeyPassword() {
        return this.httpTlsKeyPassword;
    }

    public URI getHttpExternalUri() {
        return this.httpExternalUri == null ? this.getHttpPublishUri() : this.httpExternalUri;
    }

    @ValidatorMethod
    public void validateHttpBindAddress() throws ValidationException {
        try {
            String host = this.getHttpBindAddress().getHost();
            if (!InetAddresses.isInetAddress((String)host)) {
                InetAddress inetAddress = InetAddress.getByName(host);
            }
        }
        catch (IllegalArgumentException | UnknownHostException e) {
            throw new ValidationException((Throwable)e);
        }
    }

    @ValidatorMethod
    public void validateHttpPublishUriPathEndsWithSlash() throws ValidationException {
        if (!this.getHttpPublishUri().getPath().endsWith("/")) {
            throw new ValidationException("\"http_publish_uri\" must end with a slash (\"/\")");
        }
    }

    @ValidatorMethod
    public void validateHttpExternalUriPathEndsWithSlash() throws ValidationException {
        if (!this.getHttpExternalUri().getPath().endsWith("/")) {
            throw new ValidationException("\"http_external_uri\" must end with a slash (\"/\")");
        }
    }

    @ValidatorMethod
    public void validateTlsConfig() throws ValidationException {
        if (this.isHttpEnableTls()) {
            if (!this.isRegularFileAndReadable(this.getHttpTlsKeyFile())) {
                throw new ValidationException("Unreadable or missing HTTP private key: " + this.getHttpTlsKeyFile());
            }
            if (!this.isRegularFileAndReadable(this.getHttpTlsCertFile())) {
                throw new ValidationException("Unreadable or missing HTTP X.509 certificate: " + this.getHttpTlsCertFile());
            }
        }
    }

    private boolean isRegularFileAndReadable(Path path) {
        return path != null && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
    }
}

