/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import io.krakens.grok.api.GrokUtils;
import io.krakens.grok.api.exception.GrokException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog2.database.NotFoundException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.plugin.database.ValidationException;

public interface GrokPatternService {
    public GrokPattern load(String var1) throws NotFoundException;

    public Optional<GrokPattern> loadByName(String var1);

    public Set<GrokPattern> bulkLoad(Collection<String> var1);

    public Set<GrokPattern> loadAll();

    public GrokPattern save(GrokPattern var1) throws ValidationException;

    public GrokPattern update(GrokPattern var1) throws ValidationException;

    public List<GrokPattern> saveAll(Collection<GrokPattern> var1, ImportStrategy var2) throws ValidationException;

    public Map<String, Object> match(GrokPattern var1, String var2) throws GrokException;

    public boolean validate(GrokPattern var1) throws GrokException;

    public boolean validateAll(Collection<GrokPattern> var1) throws GrokException;

    public int delete(String var1);

    public int deleteAll();

    public static Set<String> extractPatternNames(String namedPattern) {
        HashSet<String> result = new HashSet<String>();
        Set namedGroups = GrokUtils.getNameGroups((String)GrokUtils.GROK_PATTERN.namedPattern());
        Matcher matcher = Pattern.compile(GrokUtils.GROK_PATTERN.namedPattern()).matcher(namedPattern);
        while (matcher.find()) {
            Map<String, String> group = GrokPatternService.namedGroups(matcher, namedGroups);
            String patternName = group.get("pattern");
            result.add(patternName);
        }
        return result;
    }

    public static Map<String, String> namedGroups(Matcher matcher, Set<String> groupNames) {
        LinkedHashMap<String, String> namedGroups = new LinkedHashMap<String, String>();
        for (String groupName : groupNames) {
            String groupValue = matcher.group(groupName);
            namedGroups.put(groupName, groupValue);
        }
        return namedGroups;
    }

    public static enum ImportStrategy {
        ABORT_ON_CONFLICT,
        REPLACE_ON_CONFLICT,
        DROP_ALL_EXISTING;

    }
}

