/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.responses.SystemJVMResponse;
import org.graylog2.rest.models.system.responses.SystemOverviewResponse;
import org.graylog2.rest.models.system.responses.SystemProcessBufferDumpResponse;
import org.graylog2.rest.models.system.responses.SystemThreadDumpResponse;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteSystemResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster", description="System information of all nodes in the cluster")
@Path(value="/cluster")
@Produces(value={"application/json"})
public class ClusterSystemResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemResource.class);

    @Inject
    public ClusterSystemResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Timed
    @ApiOperation(value="Get system overview of all Graylog nodes")
    public Map<String, Optional<SystemOverviewResponse>> get() {
        return this.stripCallResult(this.requestOnAllNodes(RemoteSystemResource.class, RemoteSystemResource::system));
    }

    @GET
    @Timed
    @ApiOperation(value="Get JVM information of the given node")
    @Path(value="{nodeId}/jvm")
    public SystemJVMResponse jvm(@ApiParam(name="nodeId", value="The id of the node to retrieve JVM information.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemResource remoteSystemResource = this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), RemoteSystemResource.class);
        Response response = remoteSystemResource.jvm().execute();
        if (response.isSuccessful()) {
            return (SystemJVMResponse)response.body();
        }
        LOG.warn("Unable to get jvm information on node {}: {}", (Object)nodeId, (Object)response.message());
        throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a thread dump of the given node")
    @RequiresPermissions(value={"threads:dump"})
    @Path(value="{nodeId}/threaddump")
    public SystemThreadDumpResponse threadDump(@ApiParam(name="nodeId", value="The id of the node to get a thread dump.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemResource remoteSystemResource = this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), RemoteSystemResource.class);
        Response response = remoteSystemResource.threadDump().execute();
        if (response.isSuccessful()) {
            return (SystemThreadDumpResponse)response.body();
        }
        LOG.warn("Unable to get thread dump on node {}: {}", (Object)nodeId, (Object)response.message());
        throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a process buffer dump of the given node")
    @RequiresPermissions(value={"processbuffer:dump"})
    @Path(value="{nodeId}/processbufferdump")
    public SystemProcessBufferDumpResponse processBufferDump(@ApiParam(name="nodeId", value="The id of the node to get a process buffer dump.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemResource remoteSystemResource = this.remoteInterfaceProvider.get(targetNode, this.getAuthenticationToken(), RemoteSystemResource.class);
        Response response = remoteSystemResource.processBufferDump().execute();
        if (response.isSuccessful()) {
            return (SystemProcessBufferDumpResponse)response.body();
        }
        LOG.warn("Unable to get process buffer dump on node {}: {}", (Object)nodeId, (Object)response.message());
        throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a process buffer dump of all cluster nodes")
    @RequiresPermissions(value={"processbuffer:dump"})
    @Path(value="processbufferdump")
    public Map<String, Optional<SystemProcessBufferDumpResponse>> clusterProcessBufferDump() {
        return this.stripCallResult(this.requestOnAllNodes(RemoteSystemResource.class, RemoteSystemResource::processBufferDump));
    }
}

