/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Notifications", description="Notifications generated by the system", tags={"cloud"})
@Path(value="/system/notifications")
public class NotificationsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationsResource.class);
    private final NotificationService notificationService;

    @Inject
    public NotificationsResource(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get all active notifications")
    @Produces(value={"application/json"})
    public Map<String, Object> listNotifications() {
        ArrayList notifications = Lists.newArrayList();
        for (Notification n : this.notificationService.all()) {
            String notificationType = n.getType().toString().toLowerCase(Locale.ENGLISH);
            if (!this.isPermitted("notifications:read", notificationType)) continue;
            Map<String, Object> notification = n.asMap();
            try {
                notifications.add(notification);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("There is a notification type we can't handle: [" + n.getType() + "]");
            }
        }
        return ImmutableMap.of((Object)"total", (Object)notifications.size(), (Object)"notifications", (Object)notifications);
    }

    @DELETE
    @Timed
    @Path(value="/{notificationType}")
    @ApiOperation(value="Delete a notification by type")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such notification type.")})
    @AuditEvent(type="server:system_notification:delete")
    public void deleteNotification(@ApiParam(name="notificationType") @PathParam(value="notificationType") String notificationType) {
        this.deleteKeyedNotification(notificationType, null);
    }

    @DELETE
    @Timed
    @Path(value="/{notificationType}/{notificationKey}")
    @ApiOperation(value="Delete a notification by type and key")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=404, message="No such notification type.")})
    @AuditEvent(type="server:system_notification:delete")
    public void deleteKeyedNotification(@ApiParam(name="notificationType") @PathParam(value="notificationType") String notificationType, @ApiParam(name="notificationKey") @PathParam(value="notificationKey") @Nullable String notificationKey) {
        Notification.Type type;
        this.checkPermission("notifications:delete", notificationType);
        try {
            type = Notification.Type.valueOf(notificationType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("No such notification type: [" + notificationType + "]");
            throw new BadRequestException((Throwable)e);
        }
        this.notificationService.destroyAllByTypeAndKey(type, notificationKey);
    }
}

