/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.exceptionmappers;

import com.google.common.base.Strings;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;
import org.graylog2.plugin.rest.ApiError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AnyExceptionClassMapper
implements ExtendedExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(AnyExceptionClassMapper.class);

    public boolean isMappable(Exception exception) {
        return !(exception instanceof WebApplicationException);
    }

    public Response toResponse(Exception exception) {
        LOG.error("Unhandled exception in REST resource", (Throwable)exception);
        String message = Strings.nullToEmpty((String)exception.getMessage());
        ApiError apiError = ApiError.create(message);
        return Response.serverError().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)apiError).build();
    }
}

