package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.events.processor.aggregation.AggregationFunction;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationSeriesEntity extends AggregationSeriesEntity {

  private final AggregationFunction function;

  private final Optional<String> field;

  private AutoValue_AggregationSeriesEntity(
      AggregationFunction function,
      @Nullable Optional<String> field) {
    this.function = function;
    this.field = field;
  }

  @JsonProperty("function")
  @Override
  public AggregationFunction function() {
    return function;
  }

  @Nullable
  @JsonProperty("field")
  @Override
  public Optional<String> field() {
    return field;
  }

  @Override
  public String toString() {
    return "AggregationSeriesEntity{"
        + "function=" + function + ", "
        + "field=" + field
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationSeriesEntity) {
      AggregationSeriesEntity that = (AggregationSeriesEntity) o;
      return this.function.equals(that.function())
          && (this.field == null ? that.field() == null : this.field.equals(that.field()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= function.hashCode();
    h$ *= 1000003;
    h$ ^= (field == null) ? 0 : field.hashCode();
    return h$;
  }

  @Override
  public AggregationSeriesEntity.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationSeriesEntity.Builder {
    private AggregationFunction function;
    private Optional<String> field;
    Builder() {
    }
    private Builder(AggregationSeriesEntity source) {
      this.function = source.function();
      this.field = source.field();
    }
    @Override
    public AggregationSeriesEntity.Builder function(AggregationFunction function) {
      if (function == null) {
        throw new NullPointerException("Null function");
      }
      this.function = function;
      return this;
    }
    @Override
    public AggregationSeriesEntity.Builder field(@Nullable String field) {
      this.field = Optional.ofNullable(field);
      return this;
    }
    @Override
    public AggregationSeriesEntity build() {
      String missing = "";
      if (this.function == null) {
        missing += " function";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationSeriesEntity(
          this.function,
          this.field);
    }
  }

}
