package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.notifications.EventNotificationSettings;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventDefinitionEntity extends EventDefinitionEntity {

  private final ValueReference scope;

  private final ValueReference title;

  private final ValueReference description;

  private final DateTime updatedAt;

  private final ValueReference priority;

  private final ValueReference alert;

  private final EventProcessorConfigEntity config;

  private final ImmutableMap<String, EventFieldSpec> fieldSpec;

  private final ImmutableList<String> keySpec;

  private final EventNotificationSettings notificationSettings;

  private final ImmutableList<EventNotificationHandlerConfigEntity> notifications;

  private final ImmutableList<EventStorageHandler.Config> storage;

  private final ValueReference isScheduled;

  private AutoValue_EventDefinitionEntity(
      @Nullable ValueReference scope,
      ValueReference title,
      ValueReference description,
      @Nullable DateTime updatedAt,
      ValueReference priority,
      ValueReference alert,
      EventProcessorConfigEntity config,
      ImmutableMap<String, EventFieldSpec> fieldSpec,
      ImmutableList<String> keySpec,
      EventNotificationSettings notificationSettings,
      ImmutableList<EventNotificationHandlerConfigEntity> notifications,
      ImmutableList<EventStorageHandler.Config> storage,
      ValueReference isScheduled) {
    this.scope = scope;
    this.title = title;
    this.description = description;
    this.updatedAt = updatedAt;
    this.priority = priority;
    this.alert = alert;
    this.config = config;
    this.fieldSpec = fieldSpec;
    this.keySpec = keySpec;
    this.notificationSettings = notificationSettings;
    this.notifications = notifications;
    this.storage = storage;
    this.isScheduled = isScheduled;
  }

  @Nullable
  @JsonProperty("_scope")
  @Override
  public ValueReference scope() {
    return scope;
  }

  @JsonProperty("title")
  @Override
  public ValueReference title() {
    return title;
  }

  @JsonProperty("description")
  @Override
  public ValueReference description() {
    return description;
  }

  @Nullable
  @JsonProperty("updated_at")
  @Override
  public DateTime updatedAt() {
    return updatedAt;
  }

  @JsonProperty("priority")
  @Override
  public ValueReference priority() {
    return priority;
  }

  @JsonProperty("alert")
  @Override
  public ValueReference alert() {
    return alert;
  }

  @JsonProperty("config")
  @Override
  public EventProcessorConfigEntity config() {
    return config;
  }

  @JsonProperty("field_spec")
  @Override
  public ImmutableMap<String, EventFieldSpec> fieldSpec() {
    return fieldSpec;
  }

  @JsonProperty("key_spec")
  @Override
  public ImmutableList<String> keySpec() {
    return keySpec;
  }

  @JsonProperty("notification_settings")
  @Override
  public EventNotificationSettings notificationSettings() {
    return notificationSettings;
  }

  @JsonProperty("notifications")
  @Override
  public ImmutableList<EventNotificationHandlerConfigEntity> notifications() {
    return notifications;
  }

  @JsonProperty("storage")
  @Override
  public ImmutableList<EventStorageHandler.Config> storage() {
    return storage;
  }

  @JsonProperty("is_scheduled")
  @Override
  public ValueReference isScheduled() {
    return isScheduled;
  }

  @Override
  public String toString() {
    return "EventDefinitionEntity{"
        + "scope=" + scope + ", "
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "updatedAt=" + updatedAt + ", "
        + "priority=" + priority + ", "
        + "alert=" + alert + ", "
        + "config=" + config + ", "
        + "fieldSpec=" + fieldSpec + ", "
        + "keySpec=" + keySpec + ", "
        + "notificationSettings=" + notificationSettings + ", "
        + "notifications=" + notifications + ", "
        + "storage=" + storage + ", "
        + "isScheduled=" + isScheduled
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventDefinitionEntity) {
      EventDefinitionEntity that = (EventDefinitionEntity) o;
      return (this.scope == null ? that.scope() == null : this.scope.equals(that.scope()))
          && this.title.equals(that.title())
          && this.description.equals(that.description())
          && (this.updatedAt == null ? that.updatedAt() == null : this.updatedAt.equals(that.updatedAt()))
          && this.priority.equals(that.priority())
          && this.alert.equals(that.alert())
          && this.config.equals(that.config())
          && this.fieldSpec.equals(that.fieldSpec())
          && this.keySpec.equals(that.keySpec())
          && this.notificationSettings.equals(that.notificationSettings())
          && this.notifications.equals(that.notifications())
          && this.storage.equals(that.storage())
          && this.isScheduled.equals(that.isScheduled());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (scope == null) ? 0 : scope.hashCode();
    h$ *= 1000003;
    h$ ^= title.hashCode();
    h$ *= 1000003;
    h$ ^= description.hashCode();
    h$ *= 1000003;
    h$ ^= (updatedAt == null) ? 0 : updatedAt.hashCode();
    h$ *= 1000003;
    h$ ^= priority.hashCode();
    h$ *= 1000003;
    h$ ^= alert.hashCode();
    h$ *= 1000003;
    h$ ^= config.hashCode();
    h$ *= 1000003;
    h$ ^= fieldSpec.hashCode();
    h$ *= 1000003;
    h$ ^= keySpec.hashCode();
    h$ *= 1000003;
    h$ ^= notificationSettings.hashCode();
    h$ *= 1000003;
    h$ ^= notifications.hashCode();
    h$ *= 1000003;
    h$ ^= storage.hashCode();
    h$ *= 1000003;
    h$ ^= isScheduled.hashCode();
    return h$;
  }

  @Override
  public EventDefinitionEntity.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventDefinitionEntity.Builder {
    private ValueReference scope;
    private ValueReference title;
    private ValueReference description;
    private DateTime updatedAt;
    private ValueReference priority;
    private ValueReference alert;
    private EventProcessorConfigEntity config;
    private ImmutableMap<String, EventFieldSpec> fieldSpec;
    private ImmutableList<String> keySpec;
    private EventNotificationSettings notificationSettings;
    private ImmutableList<EventNotificationHandlerConfigEntity> notifications;
    private ImmutableList<EventStorageHandler.Config> storage;
    private ValueReference isScheduled;
    Builder() {
    }
    private Builder(EventDefinitionEntity source) {
      this.scope = source.scope();
      this.title = source.title();
      this.description = source.description();
      this.updatedAt = source.updatedAt();
      this.priority = source.priority();
      this.alert = source.alert();
      this.config = source.config();
      this.fieldSpec = source.fieldSpec();
      this.keySpec = source.keySpec();
      this.notificationSettings = source.notificationSettings();
      this.notifications = source.notifications();
      this.storage = source.storage();
      this.isScheduled = source.isScheduled();
    }
    @Override
    public EventDefinitionEntity.Builder scope(ValueReference scope) {
      this.scope = scope;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder title(ValueReference title) {
      if (title == null) {
        throw new NullPointerException("Null title");
      }
      this.title = title;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder description(ValueReference description) {
      if (description == null) {
        throw new NullPointerException("Null description");
      }
      this.description = description;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder updatedAt(DateTime updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder priority(ValueReference priority) {
      if (priority == null) {
        throw new NullPointerException("Null priority");
      }
      this.priority = priority;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder alert(ValueReference alert) {
      if (alert == null) {
        throw new NullPointerException("Null alert");
      }
      this.alert = alert;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder config(EventProcessorConfigEntity config) {
      if (config == null) {
        throw new NullPointerException("Null config");
      }
      this.config = config;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder fieldSpec(ImmutableMap<String, EventFieldSpec> fieldSpec) {
      if (fieldSpec == null) {
        throw new NullPointerException("Null fieldSpec");
      }
      this.fieldSpec = fieldSpec;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder keySpec(ImmutableList<String> keySpec) {
      if (keySpec == null) {
        throw new NullPointerException("Null keySpec");
      }
      this.keySpec = keySpec;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder notificationSettings(EventNotificationSettings notificationSettings) {
      if (notificationSettings == null) {
        throw new NullPointerException("Null notificationSettings");
      }
      this.notificationSettings = notificationSettings;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder notifications(ImmutableList<EventNotificationHandlerConfigEntity> notifications) {
      if (notifications == null) {
        throw new NullPointerException("Null notifications");
      }
      this.notifications = notifications;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder storage(ImmutableList<EventStorageHandler.Config> storage) {
      if (storage == null) {
        throw new NullPointerException("Null storage");
      }
      this.storage = storage;
      return this;
    }
    @Override
    public EventDefinitionEntity.Builder isScheduled(ValueReference isScheduled) {
      if (isScheduled == null) {
        throw new NullPointerException("Null isScheduled");
      }
      this.isScheduled = isScheduled;
      return this;
    }
    @Override
    public EventDefinitionEntity build() {
      String missing = "";
      if (this.title == null) {
        missing += " title";
      }
      if (this.description == null) {
        missing += " description";
      }
      if (this.priority == null) {
        missing += " priority";
      }
      if (this.alert == null) {
        missing += " alert";
      }
      if (this.config == null) {
        missing += " config";
      }
      if (this.fieldSpec == null) {
        missing += " fieldSpec";
      }
      if (this.keySpec == null) {
        missing += " keySpec";
      }
      if (this.notificationSettings == null) {
        missing += " notificationSettings";
      }
      if (this.notifications == null) {
        missing += " notifications";
      }
      if (this.storage == null) {
        missing += " storage";
      }
      if (this.isScheduled == null) {
        missing += " isScheduled";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventDefinitionEntity(
          this.scope,
          this.title,
          this.description,
          this.updatedAt,
          this.priority,
          this.alert,
          this.config,
          this.fieldSpec,
          this.keySpec,
          this.notificationSettings,
          this.notifications,
          this.storage,
          this.isScheduled);
    }
  }

}
