package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;
import org.graylog2.security.encryption.EncryptedValue;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_HTTPEventNotificationConfig extends HTTPEventNotificationConfig {

  private final String type;

  private final EncryptedValue basicAuth;

  private final boolean apiKeyAsHeader;

  private final String apiKey;

  private final EncryptedValue apiSecret;

  private final String url;

  private final boolean skipTLSVerification;

  private AutoValue_HTTPEventNotificationConfig(
      String type,
      @Nullable EncryptedValue basicAuth,
      boolean apiKeyAsHeader,
      @Nullable String apiKey,
      @Nullable EncryptedValue apiSecret,
      String url,
      boolean skipTLSVerification) {
    this.type = type;
    this.basicAuth = basicAuth;
    this.apiKeyAsHeader = apiKeyAsHeader;
    this.apiKey = apiKey;
    this.apiSecret = apiSecret;
    this.url = url;
    this.skipTLSVerification = skipTLSVerification;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("basic_auth")
  @Nullable
  @Override
  public EncryptedValue basicAuth() {
    return basicAuth;
  }

  @JsonProperty("api_key_as_header")
  @Override
  public boolean apiKeyAsHeader() {
    return apiKeyAsHeader;
  }

  @JsonProperty("api_key")
  @Nullable
  @Override
  public String apiKey() {
    return apiKey;
  }

  @JsonProperty("api_secret")
  @Nullable
  @Override
  public EncryptedValue apiSecret() {
    return apiSecret;
  }

  @JsonProperty("url")
  @Override
  public String url() {
    return url;
  }

  @JsonProperty("skip_tls_verification")
  @Override
  public boolean skipTLSVerification() {
    return skipTLSVerification;
  }

  @Override
  public String toString() {
    return "HTTPEventNotificationConfig{"
        + "type=" + type + ", "
        + "basicAuth=" + basicAuth + ", "
        + "apiKeyAsHeader=" + apiKeyAsHeader + ", "
        + "apiKey=" + apiKey + ", "
        + "apiSecret=" + apiSecret + ", "
        + "url=" + url + ", "
        + "skipTLSVerification=" + skipTLSVerification
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof HTTPEventNotificationConfig) {
      HTTPEventNotificationConfig that = (HTTPEventNotificationConfig) o;
      return this.type.equals(that.type())
          && (this.basicAuth == null ? that.basicAuth() == null : this.basicAuth.equals(that.basicAuth()))
          && this.apiKeyAsHeader == that.apiKeyAsHeader()
          && (this.apiKey == null ? that.apiKey() == null : this.apiKey.equals(that.apiKey()))
          && (this.apiSecret == null ? that.apiSecret() == null : this.apiSecret.equals(that.apiSecret()))
          && this.url.equals(that.url())
          && this.skipTLSVerification == that.skipTLSVerification();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (basicAuth == null) ? 0 : basicAuth.hashCode();
    h$ *= 1000003;
    h$ ^= apiKeyAsHeader ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (apiKey == null) ? 0 : apiKey.hashCode();
    h$ *= 1000003;
    h$ ^= (apiSecret == null) ? 0 : apiSecret.hashCode();
    h$ *= 1000003;
    h$ ^= url.hashCode();
    h$ *= 1000003;
    h$ ^= skipTLSVerification ? 1231 : 1237;
    return h$;
  }

  @Override
  public HTTPEventNotificationConfig.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends HTTPEventNotificationConfig.Builder {
    private String type;
    private EncryptedValue basicAuth;
    private Boolean apiKeyAsHeader;
    private String apiKey;
    private EncryptedValue apiSecret;
    private String url;
    private Boolean skipTLSVerification;
    Builder() {
    }
    private Builder(HTTPEventNotificationConfig source) {
      this.type = source.type();
      this.basicAuth = source.basicAuth();
      this.apiKeyAsHeader = source.apiKeyAsHeader();
      this.apiKey = source.apiKey();
      this.apiSecret = source.apiSecret();
      this.url = source.url();
      this.skipTLSVerification = source.skipTLSVerification();
    }
    @Override
    public HTTPEventNotificationConfig.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig.Builder basicAuth(EncryptedValue basicAuth) {
      this.basicAuth = basicAuth;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig.Builder apiKeyAsHeader(boolean apiKeyAsHeader) {
      this.apiKeyAsHeader = apiKeyAsHeader;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig.Builder apiKey(String apiKey) {
      this.apiKey = apiKey;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig.Builder apiSecret(EncryptedValue apiSecret) {
      this.apiSecret = apiSecret;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig.Builder url(String url) {
      if (url == null) {
        throw new NullPointerException("Null url");
      }
      this.url = url;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig.Builder skipTLSVerification(boolean skipTLSVerification) {
      this.skipTLSVerification = skipTLSVerification;
      return this;
    }
    @Override
    public HTTPEventNotificationConfig build() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.apiKeyAsHeader == null) {
        missing += " apiKeyAsHeader";
      }
      if (this.url == null) {
        missing += " url";
      }
      if (this.skipTLSVerification == null) {
        missing += " skipTLSVerification";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_HTTPEventNotificationConfig(
          this.type,
          this.basicAuth,
          this.apiKeyAsHeader,
          this.apiKey,
          this.apiSecret,
          this.url,
          this.skipTLSVerification);
    }
  }

}
