package org.graylog.events.processor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.String;
import javax.annotation.Nullable;
import org.graylog.events.context.EventDefinitionContextService;
import org.graylog.events.fields.EventFieldSpec;
import org.graylog.events.notifications.EventNotificationHandler;
import org.graylog.events.notifications.EventNotificationSettings;
import org.graylog.events.processor.storage.EventStorageHandler;
import org.joda.time.DateTime;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_EventDefinitionDto extends $AutoValue_EventDefinitionDto {
  AutoValue_EventDefinitionDto(String scope, String id, String title, String description,
      DateTime updatedAt, int priority, boolean alert, EventProcessorConfig config,
      ImmutableMap<String, EventFieldSpec> fieldSpec, ImmutableList<String> keySpec,
      EventNotificationSettings notificationSettings,
      ImmutableList<EventNotificationHandler.Config> notifications,
      ImmutableList<EventStorageHandler.Config> storage,
      EventDefinitionContextService.SchedulerCtx schedulerCtx) {
    super(scope, id, title, description, updatedAt, priority, alert, config, fieldSpec, keySpec, notificationSettings, notifications, storage, schedulerCtx);
  }

  @JsonIgnore
  public final String getScope() {
    return scope();
  }

  @JsonIgnore
  @Id
  @ObjectId
  @Nullable
  public final String getId() {
    return id();
  }

  @JsonIgnore
  public final String getTitle() {
    return title();
  }

  @JsonIgnore
  public final String getDescription() {
    return description();
  }

  @JsonIgnore
  @Nullable
  public final DateTime getUpdatedAt() {
    return updatedAt();
  }

  @JsonIgnore
  public final int getPriority() {
    return priority();
  }

  @JsonIgnore
  public final boolean isAlert() {
    return alert();
  }

  @JsonIgnore
  public final EventProcessorConfig getConfig() {
    return config();
  }

  @JsonIgnore
  public final ImmutableMap<String, EventFieldSpec> getFieldSpec() {
    return fieldSpec();
  }

  @JsonIgnore
  public final ImmutableList<String> getKeySpec() {
    return keySpec();
  }

  @JsonIgnore
  public final EventNotificationSettings getNotificationSettings() {
    return notificationSettings();
  }

  @JsonIgnore
  public final ImmutableList<EventNotificationHandler.Config> getNotifications() {
    return notifications();
  }

  @JsonIgnore
  public final ImmutableList<EventStorageHandler.Config> getStorage() {
    return storage();
  }

  @JsonIgnore
  @Nullable
  public final EventDefinitionContextService.SchedulerCtx getSchedulerCtx() {
    return schedulerCtx();
  }
}
