package org.graylog.events.processor;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_EventProcessorExecutionJob_Config extends EventProcessorExecutionJob.Config {

  private final String type;

  private final String eventDefinitionId;

  private final EventProcessorParametersWithTimerange parameters;

  private final long processingWindowSize;

  private final long processingHopSize;

  private AutoValue_EventProcessorExecutionJob_Config(
      String type,
      String eventDefinitionId,
      EventProcessorParametersWithTimerange parameters,
      long processingWindowSize,
      long processingHopSize) {
    this.type = type;
    this.eventDefinitionId = eventDefinitionId;
    this.parameters = parameters;
    this.processingWindowSize = processingWindowSize;
    this.processingHopSize = processingHopSize;
  }

  @JsonProperty("type")
  @Override
  public String type() {
    return type;
  }

  @JsonProperty("event_definition_id")
  @Override
  public String eventDefinitionId() {
    return eventDefinitionId;
  }

  @JsonProperty("parameters")
  @Override
  public EventProcessorParametersWithTimerange parameters() {
    return parameters;
  }

  @JsonProperty("processing_window_size")
  @Override
  public long processingWindowSize() {
    return processingWindowSize;
  }

  @JsonProperty("processing_hop_size")
  @Override
  public long processingHopSize() {
    return processingHopSize;
  }

  @Override
  public String toString() {
    return "Config{"
        + "type=" + type + ", "
        + "eventDefinitionId=" + eventDefinitionId + ", "
        + "parameters=" + parameters + ", "
        + "processingWindowSize=" + processingWindowSize + ", "
        + "processingHopSize=" + processingHopSize
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof EventProcessorExecutionJob.Config) {
      EventProcessorExecutionJob.Config that = (EventProcessorExecutionJob.Config) o;
      return this.type.equals(that.type())
          && this.eventDefinitionId.equals(that.eventDefinitionId())
          && this.parameters.equals(that.parameters())
          && this.processingWindowSize == that.processingWindowSize()
          && this.processingHopSize == that.processingHopSize();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= eventDefinitionId.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((processingWindowSize >>> 32) ^ processingWindowSize);
    h$ *= 1000003;
    h$ ^= (int) ((processingHopSize >>> 32) ^ processingHopSize);
    return h$;
  }

  @Override
  public EventProcessorExecutionJob.Config.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends EventProcessorExecutionJob.Config.Builder {
    private String type;
    private String eventDefinitionId;
    private EventProcessorParametersWithTimerange parameters;
    private Long processingWindowSize;
    private Long processingHopSize;
    Builder() {
    }
    private Builder(EventProcessorExecutionJob.Config source) {
      this.type = source.type();
      this.eventDefinitionId = source.eventDefinitionId();
      this.parameters = source.parameters();
      this.processingWindowSize = source.processingWindowSize();
      this.processingHopSize = source.processingHopSize();
    }
    @Override
    public EventProcessorExecutionJob.Config.Builder type(String type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public EventProcessorExecutionJob.Config.Builder eventDefinitionId(String eventDefinitionId) {
      if (eventDefinitionId == null) {
        throw new NullPointerException("Null eventDefinitionId");
      }
      this.eventDefinitionId = eventDefinitionId;
      return this;
    }
    @Override
    public EventProcessorExecutionJob.Config.Builder parameters(EventProcessorParametersWithTimerange parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public EventProcessorExecutionJob.Config.Builder processingWindowSize(long processingWindowSize) {
      this.processingWindowSize = processingWindowSize;
      return this;
    }
    @Override
    public EventProcessorExecutionJob.Config.Builder processingHopSize(long processingHopSize) {
      this.processingHopSize = processingHopSize;
      return this;
    }
    @Override
    EventProcessorExecutionJob.Config autoBuild() {
      String missing = "";
      if (this.type == null) {
        missing += " type";
      }
      if (this.eventDefinitionId == null) {
        missing += " eventDefinitionId";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.processingWindowSize == null) {
        missing += " processingWindowSize";
      }
      if (this.processingHopSize == null) {
        missing += " processingHopSize";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_EventProcessorExecutionJob_Config(
          this.type,
          this.eventDefinitionId,
          this.parameters,
          this.processingWindowSize,
          this.processingHopSize);
    }
  }

}
