package org.graylog.events.processor.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AggregationResult extends AggregationResult {

  private final ImmutableList<AggregationKeyResult> keyResults;

  private final AbsoluteRange effectiveTimerange;

  private final long totalAggregatedMessages;

  private final Set<String> sourceStreams;

  private AutoValue_AggregationResult(
      ImmutableList<AggregationKeyResult> keyResults,
      AbsoluteRange effectiveTimerange,
      long totalAggregatedMessages,
      Set<String> sourceStreams) {
    this.keyResults = keyResults;
    this.effectiveTimerange = effectiveTimerange;
    this.totalAggregatedMessages = totalAggregatedMessages;
    this.sourceStreams = sourceStreams;
  }

  @Override
  public ImmutableList<AggregationKeyResult> keyResults() {
    return keyResults;
  }

  @Override
  public AbsoluteRange effectiveTimerange() {
    return effectiveTimerange;
  }

  @Override
  public long totalAggregatedMessages() {
    return totalAggregatedMessages;
  }

  @Override
  public Set<String> sourceStreams() {
    return sourceStreams;
  }

  @Override
  public String toString() {
    return "AggregationResult{"
        + "keyResults=" + keyResults + ", "
        + "effectiveTimerange=" + effectiveTimerange + ", "
        + "totalAggregatedMessages=" + totalAggregatedMessages + ", "
        + "sourceStreams=" + sourceStreams
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AggregationResult) {
      AggregationResult that = (AggregationResult) o;
      return this.keyResults.equals(that.keyResults())
          && this.effectiveTimerange.equals(that.effectiveTimerange())
          && this.totalAggregatedMessages == that.totalAggregatedMessages()
          && this.sourceStreams.equals(that.sourceStreams());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= keyResults.hashCode();
    h$ *= 1000003;
    h$ ^= effectiveTimerange.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((totalAggregatedMessages >>> 32) ^ totalAggregatedMessages);
    h$ *= 1000003;
    h$ ^= sourceStreams.hashCode();
    return h$;
  }

  @Override
  public AggregationResult.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends AggregationResult.Builder {
    private ImmutableList<AggregationKeyResult> keyResults;
    private AbsoluteRange effectiveTimerange;
    private Long totalAggregatedMessages;
    private Set<String> sourceStreams;
    Builder() {
    }
    private Builder(AggregationResult source) {
      this.keyResults = source.keyResults();
      this.effectiveTimerange = source.effectiveTimerange();
      this.totalAggregatedMessages = source.totalAggregatedMessages();
      this.sourceStreams = source.sourceStreams();
    }
    @Override
    public AggregationResult.Builder keyResults(List<AggregationKeyResult> keyResults) {
      this.keyResults = ImmutableList.copyOf(keyResults);
      return this;
    }
    @Override
    public AggregationResult.Builder effectiveTimerange(AbsoluteRange effectiveTimerange) {
      if (effectiveTimerange == null) {
        throw new NullPointerException("Null effectiveTimerange");
      }
      this.effectiveTimerange = effectiveTimerange;
      return this;
    }
    @Override
    public AggregationResult.Builder totalAggregatedMessages(long totalAggregatedMessages) {
      this.totalAggregatedMessages = totalAggregatedMessages;
      return this;
    }
    @Override
    public AggregationResult.Builder sourceStreams(Set<String> sourceStreams) {
      if (sourceStreams == null) {
        throw new NullPointerException("Null sourceStreams");
      }
      this.sourceStreams = sourceStreams;
      return this;
    }
    @Override
    public AggregationResult build() {
      String missing = "";
      if (this.keyResults == null) {
        missing += " keyResults";
      }
      if (this.effectiveTimerange == null) {
        missing += " effectiveTimerange";
      }
      if (this.totalAggregatedMessages == null) {
        missing += " totalAggregatedMessages";
      }
      if (this.sourceStreams == null) {
        missing += " sourceStreams";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AggregationResult(
          this.keyResults,
          this.effectiveTimerange,
          this.totalAggregatedMessages,
          this.sourceStreams);
    }
  }

}
